/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import androidx.annotation.NonNull;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

class DrmPssh {
    private static final int PSSH = StandardCharsets.UTF_8.encode("pssh").getInt();
    private static final int INT_SIZE = 4;
    private static final int ID_SIZE = 16;
    private UUID systemId;
    private final List<byte[]> keyIds = new ArrayList<byte[]>();
    private byte[] data = new byte[0];

    DrmPssh(ByteBuffer buffer) {
        if (buffer != null && buffer.remaining() >= 4) {
            int size = (buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN)).getInt();
            if (size > buffer.limit()) {
                return;
            }
            if (size < buffer.limit()) {
                buffer.limit(size);
            }
            try {
                int type = buffer.getInt();
                if (type == PSSH) {
                    int dataSize;
                    int flags = buffer.getInt();
                    int version = flags >> 24;
                    byte[] uuidBytes = new byte[16];
                    buffer.get(uuidBytes);
                    this.systemId = DrmPssh.getUUID(ByteBuffer.wrap(uuidBytes));
                    if (version > 0) {
                        int keyCount = buffer.getInt();
                        for (int i = 0; i < keyCount; ++i) {
                            byte[] keyId = new byte[16];
                            buffer.get(keyId);
                            this.keyIds.add(keyId);
                        }
                    }
                    if ((dataSize = buffer.getInt()) > 0) {
                        this.data = new byte[dataSize];
                        buffer.get(this.data, 0, this.data.length);
                    }
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof DrmPssh) {
            DrmPssh other = (DrmPssh)obj;
            return Objects.equals(this.systemId, other.systemId) && Arrays.deepEquals(this.keyIds.toArray(), other.keyIds.toArray()) && Arrays.equals(this.data, other.data);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.systemId, Arrays.hashCode(this.data), Arrays.deepHashCode(this.keyIds.toArray()));
    }

    static UUID getUUID(ByteBuffer buffer) {
        long mostSigBits = buffer.getLong();
        long leastSigBits = buffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public UUID getSystemId() {
        return this.systemId;
    }

    @NonNull
    public List<byte[]> getKeyIds() {
        return this.keyIds;
    }

    public byte[] getData() {
        return this.data;
    }
}

