/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.DeniedByServerException;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaDrm;
import android.media.MediaFormat;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import com.amazonaws.ivs.player.DrmListener;
import com.amazonaws.ivs.player.DrmPssh;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.ProtectionSystem;
import com.amazonaws.ivs.player.Releasable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=18)
class DrmSession
implements Releasable,
MediaDrm.OnEventListener {
    private final String SECURITY_LEVEL = "securityLevel";
    private final String SESSION_SHARING = "sessionSharing";
    private static final Map<UUID, DrmSession> sessions = new ConcurrentHashMap<UUID, DrmSession>();
    private final UUID systemUUID;
    private final Listener listener;
    private final MediaDrm drm;
    private final Map<DrmPssh, MediaCrypto> mediaCrypto;
    private byte[] session;
    private boolean sessionSharing;

    public static DrmSession create(UUID systemUUID, Listener listener) {
        if (MediaDrm.isCryptoSchemeSupported((UUID)systemUUID)) {
            return new DrmSession(systemUUID, listener);
        }
        return null;
    }

    public static DrmSession create(ByteBuffer systemId, long ptr) {
        return DrmSession.create(DrmPssh.getUUID(systemId), new DrmListener(ptr));
    }

    public static DrmSession get(MediaFormat format) {
        ByteBuffer protectionData;
        int i = 0;
        while ((protectionData = format.getByteBuffer("drm-" + i)) != null) {
            DrmPssh pssh = new DrmPssh(protectionData);
            UUID systemId = pssh.getSystemId();
            if (systemId != null && sessions.containsKey(systemId)) {
                return sessions.get(systemId);
            }
            ++i;
        }
        return null;
    }

    @SuppressLint(value={"UseSparseArrays"})
    private DrmSession(UUID systemUUID, Listener listener) {
        this.systemUUID = systemUUID;
        this.listener = listener;
        this.mediaCrypto = new HashMap<DrmPssh, MediaCrypto>();
        try {
            this.drm = new MediaDrm(systemUUID);
        }
        catch (UnsupportedSchemeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.drm.setOnEventListener((MediaDrm.OnEventListener)this);
        if (systemUUID.equals(ProtectionSystem.WIDEVINE.getUUID())) {
            if (this.sessionSharing) {
                try {
                    this.drm.setPropertyString("sessionSharing", "enable");
                }
                catch (IllegalStateException se) {
                    se.printStackTrace();
                }
            }
            try {
                String level = this.drm.getPropertyString("securityLevel");
                if ("L1".equals(level)) {
                    this.setWidevineSecurityLevel("L3");
                }
            }
            catch (Exception e) {
                Logging.w("Failed to set security level", e);
            }
        }
        sessions.put(systemUUID, this);
    }

    private void createSession(boolean fromProvisioning) {
        if (this.session != null) {
            this.drm.closeSession(this.session);
            this.session = null;
        }
        try {
            this.session = this.drm.openSession();
        }
        catch (NotProvisionedException e) {
            e.printStackTrace();
            if (!fromProvisioning) {
                this.listener.onProvisionRequested();
            } else {
                this.listener.onError(e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.onError(e.getMessage());
        }
    }

    public void initialize() {
        this.createSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.drm != null) {
            try {
                if (this.session != null) {
                    this.drm.closeSession(this.session);
                }
                Map<DrmPssh, MediaCrypto> map = this.mediaCrypto;
                synchronized (map) {
                    this.mediaCrypto.clear();
                }
            }
            finally {
                this.drm.release();
                sessions.remove(this.systemUUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaCrypto getMediaCrypto(MediaFormat format) {
        ByteBuffer protectionData;
        DrmPssh pssh = null;
        int i = 0;
        while ((protectionData = format.getByteBuffer("drm-" + i)) != null && !this.systemUUID.equals((pssh = new DrmPssh(protectionData)).getSystemId())) {
            ++i;
        }
        if (pssh != null) {
            Map<DrmPssh, MediaCrypto> map = this.mediaCrypto;
            synchronized (map) {
                if (this.mediaCrypto.containsKey(pssh)) {
                    return this.mediaCrypto.get(pssh);
                }
                try {
                    MediaCrypto crypto = new MediaCrypto(this.systemUUID, this.session);
                    this.mediaCrypto.put(pssh, crypto);
                    return crypto;
                }
                catch (MediaCryptoException e) {
                    e.printStackTrace();
                    this.listener.onError(e.getMessage());
                }
            }
        }
        return null;
    }

    public byte[] getSessionId() {
        return this.session;
    }

    public void onEvent(MediaDrm md, byte[] sessionId, int event, int extra, byte[] data) {
        Logging.w("MediaDrm event " + event + " extra " + extra);
        switch (event) {
            case 3: {
                this.listener.onKeyExpired();
                break;
            }
            case 2: {
                this.listener.onKeyRequested();
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public OpaqueRequest generateKeyRequest(byte[] init) {
        try {
            MediaDrm.KeyRequest keyRequest = this.drm.getKeyRequest(this.session, init, "cenc", 1, null);
            OpaqueRequest request = new OpaqueRequest();
            request.url = keyRequest.getDefaultUrl();
            request.data = keyRequest.getData();
            return request;
        }
        catch (NotProvisionedException e) {
            this.listener.onProvisionRequested();
            e.printStackTrace();
            return null;
        }
    }

    public OpaqueRequest generateProvisionRequest() {
        MediaDrm.ProvisionRequest provisionRequest = this.drm.getProvisionRequest();
        OpaqueRequest request = new OpaqueRequest();
        request.url = provisionRequest.getDefaultUrl();
        request.data = provisionRequest.getData();
        return request;
    }

    public void updateKeyResponse(byte[] data) {
        try {
            this.drm.provideKeyResponse(this.session, data);
        }
        catch (NotProvisionedException e) {
            e.printStackTrace();
            this.listener.onProvisionRequested();
        }
        catch (DeniedByServerException e) {
            e.printStackTrace();
            this.listener.onError(e.getMessage());
        }
    }

    public void updateProvisionResponse(byte[] data) {
        try {
            this.drm.provideProvisionResponse(data);
        }
        catch (DeniedByServerException e) {
            e.printStackTrace();
            this.listener.onError(e.getMessage());
            return;
        }
        if (this.session == null) {
            this.createSession(true);
        }
    }

    private void unprovision() {
        try {
            this.drm.provideProvisionResponse("unprovision".getBytes());
        }
        catch (Exception e) {
            Logging.w("Un-provision failed", e);
        }
    }

    private void setWidevineSecurityLevel(String level) {
        String currentLevel;
        if (this.systemUUID.equals(ProtectionSystem.WIDEVINE.getUUID()) && !(currentLevel = this.drm.getPropertyString("securityLevel")).equals(level)) {
            this.drm.setPropertyString("securityLevel", level);
        }
    }

    public static interface Listener {
        public void onKeyExpired();

        public void onKeyRequested();

        public void onProvisionRequested();

        public void onError(String var1);
    }

    static class OpaqueRequest {
        String url;
        byte[] data;

        OpaqueRequest() {
        }
    }
}

