/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.amazonaws.ivs.player.EGLException;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.Predicate;
import com.amazonaws.ivs.player.Releasable;
import com.amazonaws.ivs.player.Result;
import com.amazonaws.ivs.player.Supplier;

class EGLManager
implements Releasable {
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private long initTime = 0L;

    static Result<EGLException, EGLManager> create() {
        return EGLManager.create(null);
    }

    static Result<EGLException, EGLManager> create(EGLContext shareContext) {
        long startTime = System.nanoTime();
        Result<EGLException, EGLManager> eglManagerV3 = EGLManager.createDisplay().flatMap(display -> EGLManager.createConfig(display, 3).flatMap(config -> EGLManager.createContext(display, config, shareContext, 3).flatMap(context -> {
            EGLManager manager = new EGLManager((EGLDisplay)display, (EGLConfig)config, (EGLContext)context);
            manager.initTime = (System.nanoTime() - startTime) / 1000L;
            return Result.value(manager);
        })));
        if (eglManagerV3.isOk()) {
            return eglManagerV3;
        }
        return EGLManager.createDisplay().flatMap(display -> EGLManager.createConfig(display, 2).flatMap(config -> EGLManager.createContext(display, config, shareContext, 2).flatMap(context -> {
            long endTime = System.nanoTime();
            Logging.i("EGL initialization: " + (endTime - startTime) / 1000L + "us");
            return Result.value(new EGLManager((EGLDisplay)display, (EGLConfig)config, (EGLContext)context));
        })));
    }

    @Override
    public void release() {
        this.makeCurrent();
        if (this.mEGLContext != EGL14.EGL_NO_CONTEXT) {
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
        }
        EGL14.eglReleaseThread();
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLConfig = null;
    }

    String getString(int code) {
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            return "";
        }
        return GLES20.glGetString((int)code);
    }

    EGLDisplay getEGLDisplay() {
        return this.mEGLDisplay;
    }

    EGLContext getEGLContext() {
        return this.mEGLContext;
    }

    EGLConfig getEGLConfig() {
        return this.mEGLConfig;
    }

    Result<EGLException, EGLSurface> createEGLScreenSurface(@NonNull Surface surface) {
        return EGLManager.check("Create Window Surface", () -> {
            int[] surfaceAttribs = new int[]{12344};
            EGLSurface eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)surface, (int[])surfaceAttribs, (int)0);
            return eglSurface;
        });
    }

    Result<EGLException, EGLSurface> createEGLOffscreenSurface() {
        return EGLManager.check("Create Pbuffer Surface", () -> {
            int[] attribs = new int[]{12375, 1, 12374, 1, 12344};
            EGLSurface eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])attribs, (int)0);
            return eglSurface;
        });
    }

    Result<EGLException, IVSSurface> createIVSSurface(Surface surface) {
        if (surface == null) {
            return this.createEGLOffscreenSurface().map(eglSurface -> new IVSSurface(this, (EGLSurface)eglSurface));
        }
        return this.createEGLScreenSurface(surface).map(eglSurface -> new IVSSurface(this, (EGLSurface)eglSurface));
    }

    void releaseSurface(EGLSurface surface) {
        EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)surface);
    }

    private EGLManager(EGLDisplay display, EGLConfig config, EGLContext context) {
        this.mEGLDisplay = display;
        this.mEGLConfig = config;
        this.mEGLContext = context;
    }

    private static Result<EGLException, EGLDisplay> createDisplay() {
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        if (display == EGL14.EGL_NO_DISPLAY) {
            return Result.error(new EGLException("No display connection is available", -1));
        }
        return EGLManager.check("EGL Initialize", () -> display, it -> {
            int[] majorMinorVersion = new int[2];
            return EGL14.eglInitialize((EGLDisplay)it, (int[])majorMinorVersion, (int)0, (int[])majorMinorVersion, (int)1);
        });
    }

    private static Result<EGLException, EGLContext> createContext(EGLDisplay display, EGLConfig config, EGLContext shareContext, int EGLMajorVersion) {
        return EGLManager.check("Create EGL Context", () -> {
            int[] attrib_list = new int[]{12440, EGLMajorVersion, 12344};
            return EGL14.eglCreateContext((EGLDisplay)display, (EGLConfig)config, (EGLContext)(shareContext == null ? EGL14.EGL_NO_CONTEXT : shareContext), (int[])attrib_list, (int)0);
        });
    }

    private static Result<EGLException, EGLConfig> createConfig(EGLDisplay display, int EGLMajorVersion) {
        int[] numConfigs;
        EGLConfig[] configs;
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, EGLMajorVersion == 3 ? 68 : 4, 12344};
        if (!EGL14.eglChooseConfig((EGLDisplay)display, (int[])attribList, (int)0, (EGLConfig[])(configs = new EGLConfig[1]), (int)0, (int)configs.length, (int[])(numConfigs = new int[1]), (int)0)) {
            return Result.error(new EGLException("EGL choose config failed", 0));
        }
        return Result.value(configs[0]);
    }

    void makeCurrent() {
        EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
    }

    void makeCurrent(EGLSurface surface) {
        EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)surface, (EGLSurface)surface, (EGLContext)this.mEGLContext);
    }

    void makeCurrent(EGLSurface readSurface, EGLSurface writeSurface) {
        EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)readSurface, (EGLSurface)writeSurface, (EGLContext)this.mEGLContext);
    }

    private static EGLException checkInternal(String message) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            return new EGLException(message, error);
        }
        return null;
    }

    static EGLException check(String message, Runnable runnable) {
        runnable.run();
        return EGLManager.checkInternal(message);
    }

    static <V> Result<EGLException, V> check(String message, Supplier<V> supplier) {
        V value = supplier.get();
        EGLException eglException = EGLManager.checkInternal(message);
        if (eglException != null) {
            return Result.error(eglException);
        }
        return Result.value(value);
    }

    static <V> Result<EGLException, V> check(String message, Supplier<V> supplier, Predicate<V> postCondition) {
        V value = supplier.get();
        EGLException eglException = EGLManager.checkInternal(message);
        if (eglException != null) {
            return Result.error(eglException);
        }
        if (!postCondition.test(value)) {
            return Result.error(new EGLException(message + " post condition failed", -1));
        }
        return Result.value(value);
    }

    void currentCall(Runnable runnable, EGLSurface eglSurface) {
        this.makeCurrent(eglSurface);
        runnable.run();
        this.makeCurrent();
    }

    <V> V currentCall(Supplier<V> supplier, EGLSurface eglSurface) {
        this.makeCurrent(eglSurface);
        V value = supplier.get();
        this.makeCurrent();
        return value;
    }

    class IVSSurface
    implements Releasable {
        EGLManager helper;
        EGLSurface eglSurface;
        private final int[] status;

        private IVSSurface(EGLManager helper, EGLSurface surface) {
            this.helper = helper;
            this.eglSurface = surface;
            this.status = new int[1];
        }

        int width() {
            EGL14.eglQuerySurface((EGLDisplay)this.helper.getEGLDisplay(), (EGLSurface)this.eglSurface, (int)12375, (int[])this.status, (int)0);
            return this.status[0];
        }

        int height() {
            EGL14.eglQuerySurface((EGLDisplay)this.helper.getEGLDisplay(), (EGLSurface)this.eglSurface, (int)12374, (int[])this.status, (int)0);
            return this.status[0];
        }

        void setPresentationTimestamp(long timestampNs) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.helper.getEGLDisplay(), (EGLSurface)this.eglSurface, (long)timestampNs);
        }

        boolean swapBuffers() {
            return EGL14.eglSwapBuffers((EGLDisplay)this.helper.getEGLDisplay(), (EGLSurface)this.eglSurface);
        }

        @Override
        public void release() {
            this.helper.releaseSurface(this.eglSurface);
        }
    }
}

