/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import java.util.HashMap;
import java.util.Map;

public enum ErrorType {
    OK(0),
    ERROR(1),
    ERROR_NOT_SUPPORTED(2),
    ERROR_NO_SOURCE(3),
    ERROR_INVALID_DATA(4),
    ERROR_INVALID_STATE(5),
    ERROR_INVALID_PARAMETER(6),
    ERROR_TIMEOUT(7),
    ERROR_NETWORK(8),
    ERROR_NETWORK_IO(9),
    ERROR_AUTHORIZATION(10),
    ERROR_NOT_AVAILABLE(11),
    ERROR_TYPE_UNKNOWN(12);

    private static final Map<Integer, ErrorType> codeToError;
    private final int errorCode;

    private ErrorType(int code) {
        this.errorCode = code;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public static ErrorType fromInt(int code) {
        ErrorType result = codeToError.get(code);
        if (result == null) {
            result = ERROR_TYPE_UNKNOWN;
        }
        return result;
    }

    static {
        codeToError = new HashMap<Integer, ErrorType>();
        for (ErrorType e : ErrorType.values()) {
            codeToError.put(e.getErrorCode(), e);
        }
    }
}

