/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.text.TextUtils;
import com.amazonaws.ivs.experiments.ExperimentData;
import com.amazonaws.ivs.player.Logging;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

class Experiments {
    static final String GROUP_CONTROL = "control";
    static final String GROUP_TREATMENT = "treatment";
    private final EnumMap<Experiment, ExperimentData> experiments = new EnumMap(Experiment.class);

    static Map<String, String> getEntries() {
        HashMap<String, String> experiments = new HashMap<String, String>();
        for (Experiment exp : (Experiment[])Experiment.class.getEnumConstants()) {
            experiments.put(exp.id, exp.defaultGroup);
        }
        return experiments;
    }

    Experiments() {
        for (Experiment exp : Experiment.values()) {
            this.experiments.put(exp, new ExperimentData(exp.id, exp.defaultGroup, 0, ""));
        }
    }

    void setExperiment(ExperimentData data) {
        if (data != null && !TextUtils.isEmpty((CharSequence)data.getId()) && !TextUtils.isEmpty((CharSequence)data.getAssignment())) {
            Logging.d("setExperiment " + data.getId() + ":" + data.getAssignment());
            Experiment exp = Experiment.fromId(data.getId());
            if (exp == null) {
                Logging.w("Experiment ID not recognized");
            } else {
                this.experiments.put(exp, data);
            }
        }
    }

    void setExperiments(ExperimentData[] data) {
        if (data != null) {
            for (ExperimentData exp : data) {
                this.setExperiment(exp);
            }
        }
    }

    String getAssignedGroup(Experiment id) {
        if (this.experiments.containsKey((Object)id)) {
            return this.experiments.get((Object)id).getAssignment();
        }
        return null;
    }

    String getType(Experiment id) {
        if (this.experiments.containsKey((Object)id)) {
            return this.experiments.get((Object)id).getType();
        }
        return null;
    }

    Integer getVersion(Experiment id) {
        if (this.experiments.containsKey((Object)id)) {
            return this.experiments.get((Object)id).getVersion();
        }
        return null;
    }

    boolean isControl(Experiment id) {
        return GROUP_CONTROL.equals(this.getAssignedGroup(id));
    }

    Map<Experiment, ExperimentData> dumpExperiments() {
        return Collections.unmodifiableMap(this.experiments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Experiments:\n");
        for (Experiment exp : this.experiments.keySet()) {
            ExperimentData data = this.experiments.get((Object)exp);
            sb.append(exp.id).append(":").append(this.getAssignedGroup(exp)).append("\n");
        }
        return sb.toString();
    }

    static enum Experiment {
        AD_LOUDNESS("4dfcb309-1348-439f-8424-df8759481ddd", "control"),
        SEND_RECOVERABLE_NETWORK_ERROR("72cbae70-b2c0-4c99-a1e6-da6a10a39b73", "control"),
        ANDROID_GPU("9d950d59-1936-4fbc-8eaa-a0d4fe6fcb9f", "control"),
        SUPER_RESOLUTION("8110c7e7-4746-49c9-8d46-dd7835314904", "control"),
        PROBE_ENDPOINT("742b9990-2c8b-427f-b5fc-fe4ccccec50b", "control"),
        ABR_SCORE("f7582825-7bcf-4321-aec7-ceb22bf8c87e", "control"),
        ANDROID_ANALYTICS_DIRECT("dc83a207-5c45-4fc8-a1ad-0020b40ecade", "control");

        final String id;
        final String defaultGroup;
        final String type;
        final int version;
        private static final Map<String, Experiment> idToEnum;

        static Experiment fromId(String id) {
            return idToEnum.get(id);
        }

        private static Map<String, Experiment> createMapping() {
            HashMap<String, Experiment> mapping = new HashMap<String, Experiment>();
            for (Experiment exp : Experiment.values()) {
                mapping.put(exp.id, exp);
            }
            return mapping;
        }

        private Experiment(String id, String defaultGroup) {
            this.id = id;
            this.defaultGroup = defaultGroup;
            this.type = "";
            this.version = 0;
        }

        static {
            idToEnum = Collections.unmodifiableMap(Experiment.createMapping());
        }
    }
}

