/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.media.MediaFormat;
import com.amazonaws.ivs.player.MediaType;
import java.nio.ByteBuffer;
import java.util.Arrays;

class Formats {
    private static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};

    private Formats() {
    }

    public static MediaFormat createVideoFormat(String mediaType, ByteBuffer[] csd, int width, int height, ByteBuffer[] protectionData) {
        mediaType = MediaType.removeParameters(mediaType);
        MediaFormat format = MediaFormat.createVideoFormat((String)mediaType, (int)width, (int)height);
        format.setInteger("max-input-size", 0);
        if (csd != null) {
            for (int i = 0; i < csd.length; ++i) {
                csd[i] = Formats.addNALStartCodes(csd[i]);
                if (csd[i].remaining() <= 4) continue;
                format.setByteBuffer("csd-" + i, csd[i]);
            }
        }
        Formats.setProtectionData(format, protectionData);
        return format;
    }

    public static MediaFormat createAudioFormat(String mediaType, ByteBuffer[] csd, int sampleRate, int channels, ByteBuffer[] protectionData) {
        if ("audio/aac".equals(mediaType = MediaType.removeParameters(mediaType))) {
            mediaType = "audio/mp4a-latm";
        }
        MediaFormat format = MediaFormat.createAudioFormat((String)mediaType, (int)sampleRate, (int)channels);
        if (csd != null) {
            for (int i = 0; i < csd.length; ++i) {
                format.setByteBuffer("csd-" + i, csd[i]);
            }
        }
        Formats.setProtectionData(format, protectionData);
        return format;
    }

    private static void setProtectionData(MediaFormat format, ByteBuffer[] protectionData) {
        if (protectionData != null) {
            for (int i = 0; i < protectionData.length; ++i) {
                format.setByteBuffer("drm-" + i, protectionData[i]);
            }
        }
    }

    public static MediaFormat createTextFormat(String mediaType) {
        mediaType = MediaType.removeParameters(mediaType);
        return MediaFormat.createSubtitleFormat((String)mediaType, null);
    }

    private static ByteBuffer addNALStartCodes(ByteBuffer csd) {
        if (csd == null) {
            csd = ByteBuffer.allocateDirect(4);
        }
        if (csd.remaining() > 4) {
            byte[] start = new byte[4];
            csd.get(start);
            csd.rewind();
            if (Arrays.equals(start, NAL_START_CODE)) {
                return csd;
            }
        }
        ByteBuffer coded = ByteBuffer.allocateDirect(csd.remaining() + 4);
        coded.put(NAL_START_CODE);
        coded.put(csd);
        coded.rewind();
        return coded;
    }
}

