/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.Nullable;
import com.amazonaws.ivs.player.Consumer;
import com.amazonaws.ivs.player.GLError;
import com.amazonaws.ivs.player.GLException;
import com.amazonaws.ivs.player.Predicate;
import com.amazonaws.ivs.player.Releasable;
import com.amazonaws.ivs.player.Result;
import com.amazonaws.ivs.player.Supplier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

class GLManager {
    GLManager() {
    }

    static Result<GLException, Texture> createTexture(int textureTarget) {
        int[] textures = new int[1];
        return GLManager.check("Create Texture", () -> {
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            GLES20.glBindTexture((int)textureTarget, (int)textures[0]);
            GLES20.glTexParameterf((int)textureTarget, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)textureTarget, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)textureTarget, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)textureTarget, (int)10243, (float)33071.0f);
            GLES20.glBindTexture((int)textureTarget, (int)-1);
            return new Texture(textures[0], textureTarget);
        }, Texture::release);
    }

    static Result<GLException, Shader> createShader(int textureTarget) {
        String fragmentShader = "";
        if (textureTarget == 36197) {
            fragmentShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;varying vec2 vTextureCoord;uniform samplerExternalOES sTexture;void main() {gl_FragColor = texture2D(sTexture, vTextureCoord).rgba;}";
        }
        GLException shaderException = new GLException();
        Result<GLException, Integer> vertexShaderResult = Shader.createShader(35633, "uniform mat4 uMVPMatrix;uniform mat4 uTexMatrix;attribute vec4 aPosition;attribute vec4 aTextureCoord;varying vec2 vTextureCoord;void main() {gl_Position = uMVPMatrix * aPosition;vTextureCoord = (uTexMatrix * aTextureCoord).xy;}").ifError(shaderException::appendErrors);
        Result<GLException, Integer> fragmentShaderResult = Shader.createShader(35632, fragmentShader).ifError(shaderException::appendErrors);
        if (!shaderException.errors.isEmpty()) {
            return Result.error(shaderException);
        }
        Result<GLException, Integer> programResult = Shader.createShaderProgram(vertexShaderResult.getValue(), fragmentShaderResult.getValue());
        if (vertexShaderResult.isError()) {
            return Result.error(vertexShaderResult.getError());
        }
        int programHandle = programResult.getValue();
        Result<GLException, Integer> positionLocation = Shader.assignAttribLocation(programHandle, "aPosition").ifError(shaderException::appendErrors);
        Result<GLException, Integer> texCoordLocation = Shader.assignAttribLocation(programHandle, "aTextureCoord").ifError(shaderException::appendErrors);
        Result<GLException, Integer> mvpMatrixLocation = Shader.assignUniformLocation(programHandle, "uMVPMatrix").ifError(shaderException::appendErrors);
        Result<GLException, Integer> texMatrixLocation = Shader.assignUniformLocation(programHandle, "uTexMatrix").ifError(shaderException::appendErrors);
        if (shaderException.errors.isEmpty()) {
            return Result.value(new Shader(programHandle, positionLocation.getValue(), texCoordLocation.getValue(), mvpMatrixLocation.getValue(), texMatrixLocation.getValue()));
        }
        return Result.error(shaderException);
    }

    private static GLException checkInternal(String message) {
        int error;
        GLException exception = null;
        GLError glError = null;
        while ((error = GLES20.glGetError()) != 0) {
            if (glError == null) {
                glError = new GLError(message);
            }
            glError.appendErrorCode(error);
        }
        if (glError != null) {
            exception = new GLException(glError);
        }
        return exception;
    }

    @Nullable
    static GLException check(String message, Runnable runnable) {
        runnable.run();
        return GLManager.checkInternal(message);
    }

    static <V> Result<GLException, V> check(String message, Supplier<V> supplier, @Nullable Consumer<V> deleter) {
        V result = supplier.get();
        GLException glException = GLManager.checkInternal(message);
        if (glException != null) {
            if (deleter != null) {
                deleter.accept(result);
            }
            return Result.error(glException);
        }
        return Result.value(result);
    }

    static <V> Result<GLException, V> check(String message, Supplier<V> supplier, @Nullable Consumer<V> deleter, Predicate<V> postCondition) {
        V result = supplier.get();
        GLException glException = GLManager.checkInternal(message);
        if (glException != null) {
            if (deleter != null) {
                deleter.accept(result);
            }
            return Result.error(glException);
        }
        if (!postCondition.test(result)) {
            if (deleter != null) {
                deleter.accept(result);
            }
            return Result.error(new GLException(new GLError(message + " post condition failed")));
        }
        return Result.value(result);
    }

    static class Texture
    implements Releasable {
        static final int textureExternalTarget = 36197;
        static final int texture2DTarget = 3553;
        int id;
        final int targetType;
        float[] transform;
        long presentationTimestamp = 0L;

        void setPresentationTimestamp(long timestamp) {
            this.presentationTimestamp = timestamp;
        }

        private Texture(int id, int targetType) {
            this.id = id;
            this.targetType = targetType;
            this.transform = new float[16];
        }

        @Override
        public void release() {
            if (this.id >= 0) {
                int[] textures = new int[]{this.id};
                GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
                this.id = -1;
            }
        }
    }

    static class Shader
    implements Releasable {
        private static final float[] IDENTITY_MATRIX = new float[16];
        private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;uniform mat4 uTexMatrix;attribute vec4 aPosition;attribute vec4 aTextureCoord;varying vec2 vTextureCoord;void main() {gl_Position = uMVPMatrix * aPosition;vTextureCoord = (uTexMatrix * aTextureCoord).xy;}";
        private static final String FRAGMENT_SHADER_EXT = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;varying vec2 vTextureCoord;uniform samplerExternalOES sTexture;void main() {gl_FragColor = texture2D(sTexture, vTextureCoord).rgba;}";
        private final int mProgramHandle;
        private final int mMVPMatrixLocation;
        private final int mTexMatrixLocation;
        private final int mPositionLocation;
        private final int mTexCoordLocation;

        private Shader(int programHandle, int positionLocation, int texCoordLocation, int mvpMatrixLocation, int texMatrixLocation) {
            this.mProgramHandle = programHandle;
            this.mPositionLocation = positionLocation;
            this.mTexCoordLocation = texCoordLocation;
            this.mMVPMatrixLocation = mvpMatrixLocation;
            this.mTexMatrixLocation = texMatrixLocation;
        }

        private static Result<GLException, Integer> assignAttribLocation(int program, String name) {
            return GLManager.check("Assign attribute " + name, () -> GLES20.glGetAttribLocation((int)program, (String)name), null, location -> location >= 0);
        }

        private static Result<GLException, Integer> assignUniformLocation(int program, String name) {
            return GLManager.check("Assign uniform " + name, () -> GLES20.glGetUniformLocation((int)program, (String)name), null, location -> location >= 0);
        }

        GLException draw(Texture texture) {
            return GLManager.check("Draw", () -> {
                GLES20.glUseProgram((int)this.mProgramHandle);
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)texture.targetType, (int)texture.id);
                GLES20.glUniformMatrix4fv((int)this.mMVPMatrixLocation, (int)1, (boolean)false, (float[])IDENTITY_MATRIX, (int)0);
                GLES20.glUniformMatrix4fv((int)this.mTexMatrixLocation, (int)1, (boolean)false, (float[])texture.transform, (int)0);
                GLES20.glEnableVertexAttribArray((int)this.mPositionLocation);
                GLES20.glVertexAttribPointer((int)this.mPositionLocation, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)Drawable.POSITION_BUF);
                GLES20.glEnableVertexAttribArray((int)this.mTexCoordLocation);
                GLES20.glVertexAttribPointer((int)this.mTexCoordLocation, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)Drawable.TEXCOORD_BUF);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                GLES20.glDisableVertexAttribArray((int)this.mPositionLocation);
                GLES20.glDisableVertexAttribArray((int)this.mTexCoordLocation);
                GLES20.glBindTexture((int)texture.targetType, (int)0);
                GLES20.glUseProgram((int)0);
            });
        }

        @Override
        public void release() {
            GLES20.glDeleteProgram((int)this.mProgramHandle);
        }

        private static Result<GLException, Integer> createShaderProgram(int vertexShaderHandle, int fragmentShaderHandle) {
            return GLManager.check("Create Shader Program", () -> {
                int programHandle = GLES20.glCreateProgram();
                GLES20.glAttachShader((int)programHandle, (int)vertexShaderHandle);
                GLES20.glAttachShader((int)programHandle, (int)fragmentShaderHandle);
                GLES20.glLinkProgram((int)programHandle);
                return programHandle;
            }, GLES20::glDeleteProgram, programHandle -> {
                if (programHandle == 0) {
                    return false;
                }
                int[] status = new int[1];
                GLES20.glGetProgramiv((int)programHandle, (int)35714, (int[])status, (int)0);
                return status[0] != 0;
            });
        }

        private static Result<GLException, Integer> createShader(int shaderType, String source) {
            return GLManager.check("Create Vertex Shader", () -> {
                int h = GLES20.glCreateShader((int)shaderType);
                GLES20.glShaderSource((int)h, (String)source);
                GLES20.glCompileShader((int)h);
                return h;
            }, GLES20::glDeleteShader, h -> {
                int[] status = new int[1];
                GLES20.glGetShaderiv((int)h, (int)35713, (int[])status, (int)0);
                return status[0] != 0;
            });
        }

        static {
            Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
        }

        static class Drawable {
            private static final float[] POSITIONS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
            private static final float[] TEXCOORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            private static final int[] INDICES = new int[]{0, 2, 3, 1, 0, 3};
            static final int VERTEX_COUNT = 4;
            static final int POSITION_STRIDE = 8;
            static final int TEXCOORD_STRIDE = 8;
            static final FloatBuffer POSITION_BUF = Drawable.createFloatBuffer(POSITIONS);
            static final FloatBuffer TEXCOORD_BUF = Drawable.createFloatBuffer(TEXCOORDS);
            static final IntBuffer INDEX_BUF = Drawable.createIntBuffer(INDICES);

            Drawable() {
            }

            public static FloatBuffer createFloatBuffer(float[] data) {
                ByteBuffer bb = ByteBuffer.allocateDirect(data.length * 4);
                bb.order(ByteOrder.nativeOrder());
                FloatBuffer fb = bb.asFloatBuffer();
                fb.put(data);
                fb.rewind();
                return fb;
            }

            public static IntBuffer createIntBuffer(int[] data) {
                ByteBuffer bb = ByteBuffer.allocateDirect(data.length * 4);
                bb.order(ByteOrder.nativeOrder());
                IntBuffer ib = bb.asIntBuffer();
                ib.put(data);
                ib.rewind();
                return ib;
            }
        }
    }
}

