/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.text.TextUtils;
import com.amazonaws.ivs.player.EGLException;
import com.amazonaws.ivs.player.GLError;
import com.amazonaws.ivs.player.HardwareInfo;
import com.amazonaws.ivs.player.Performance;

abstract class GPUAnalyticsEvent {
    final String gpuName;
    final String gpuArchitecture;
    final String gpuVendor;

    static GPUErrorAnalyticsEvent createErrorEvent(HardwareInfo info, GLError glError) {
        int glErrorCode = 0;
        if (!glError.errorCodes.isEmpty()) {
            glErrorCode = glError.errorCodes.get(0);
        }
        return new GPUErrorAnalyticsEvent(info, glError.description, glErrorCode);
    }

    static GPUErrorAnalyticsEvent createErrorEvent(HardwareInfo info, EGLException eglError) {
        return new GPUErrorAnalyticsEvent(info, eglError.message, eglError.errorCode);
    }

    static GPUInitAnalyticsEvent createInitEvent(HardwareInfo info, Performance.Snapshot initSnapshot) {
        return new GPUInitAnalyticsEvent(info, initSnapshot, "");
    }

    static GPUStatusAnalyticsEvent createStatusEvent(HardwareInfo info, Performance.Snapshot capture, Performance.Snapshot transform, Performance.Snapshot render) {
        return new GPUStatusAnalyticsEvent(info, capture, transform, render);
    }

    GPUAnalyticsEvent(HardwareInfo info) {
        this.gpuName = info.getGPURenderer();
        this.gpuArchitecture = info.getGlVersion();
        this.gpuVendor = info.getGPURenderer();
    }

    static final class GPUErrorAnalyticsEvent
    extends GPUAnalyticsEvent {
        final String errorMessage;
        final String errorSource;
        final int errorCode;

        GPUErrorAnalyticsEvent(HardwareInfo info, String errorMessage, int errorCode) {
            super(info);
            this.errorMessage = errorMessage;
            this.errorSource = "";
            this.errorCode = errorCode;
        }
    }

    static final class GPUInitAnalyticsEvent
    extends GPUAnalyticsEvent {
        final long cpuCoreCount;
        final String gpuFeatures;
        final long totalRam;
        final float timeInit;
        final String gpuConfig;

        private GPUInitAnalyticsEvent(HardwareInfo info, Performance.Snapshot initSnapshot, String gpuConfig) {
            super(info);
            this.cpuCoreCount = info.getTotalCoreCount();
            this.gpuFeatures = TextUtils.join((CharSequence)",", (Object[])info.getGPUExtensions());
            this.totalRam = info.getTotalMemory();
            this.timeInit = initSnapshot.time();
            this.gpuConfig = gpuConfig;
        }
    }

    static final class GPUStatusAnalyticsEvent
    extends GPUAnalyticsEvent {
        final int framesCaptured;
        final int framesTransformed;
        final int framesRendered;
        final float timeCapture;
        final float timeTransform;
        final float timeRender;
        final float timeEndToEnd;

        private GPUStatusAnalyticsEvent(HardwareInfo info, Performance.Snapshot capture, Performance.Snapshot transform, Performance.Snapshot render) {
            super(info);
            this.framesCaptured = capture.samples();
            this.timeCapture = capture.time();
            this.framesTransformed = transform.samples();
            this.timeTransform = transform.time();
            this.framesRendered = render.samples();
            this.timeRender = render.time();
            this.timeEndToEnd = this.timeCapture + this.timeTransform + this.timeRender;
        }
    }
}

