/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.app.ActivityManager;
import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLSurface;
import com.amazonaws.ivs.player.EGLException;
import com.amazonaws.ivs.player.EGLManager;
import com.amazonaws.ivs.player.Releasable;
import com.amazonaws.ivs.player.Result;
import java.util.Arrays;

class HardwareInfo
implements Releasable {
    EGLManager eglManager;
    EGLSurface surface;
    private final Context context;

    String getGPUVendor() {
        return this.eglManager.currentCall(() -> this.eglManager.getString(7936), this.surface);
    }

    String getGlVersion() {
        return this.eglManager.currentCall(() -> this.eglManager.getString(7938), this.surface);
    }

    String getGPURenderer() {
        return this.eglManager.currentCall(() -> this.eglManager.getString(7937), this.surface);
    }

    String[] getGPUExtensions() {
        String extensions = this.eglManager.currentCall(() -> this.eglManager.getString(7939), this.surface);
        if (!extensions.isEmpty()) {
            Object[] splitExtensions = extensions.split(" ");
            Arrays.sort(splitExtensions);
            return splitExtensions;
        }
        return new String[0];
    }

    long getTotalMemory() {
        ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
        ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
        manager.getMemoryInfo(info);
        return info.totalMem;
    }

    long getTotalCoreCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    static Result<EGLException, HardwareInfo> create(Context context, EGLManager eglManager) {
        return eglManager.createEGLOffscreenSurface().flatMap(surface -> Result.value(new HardwareInfo(context, eglManager, (EGLSurface)surface)));
    }

    private HardwareInfo(Context context, EGLManager graphics, EGLSurface surface) {
        this.context = context;
        this.eglManager = graphics;
        this.surface = surface;
    }

    @Override
    public void release() {
        this.eglManager.releaseSurface(this.surface);
        this.surface = EGL14.EGL_NO_SURFACE;
    }
}

