/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazonaws.ivs.player.ErrorType;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.Quality;
import com.amazonaws.ivs.player.Source;
import com.amazonaws.ivs.player.SourceGroup;
import java.util.HashSet;
import java.util.Set;

public class HlsSource
implements Source {
    private long native_source;
    private final Handler handler;
    private final Source.Listener listener;

    private native void release(long var1);

    private native String getId(long var1);

    private native String getUri(long var1);

    private native String getManifest(long var1);

    private native String getSessionData(long var1, String var3);

    private native Set<Quality> getQualities(long var1);

    private native Set<SourceGroup> getGroups(long var1);

    private native long getTimeToLive(long var1);

    protected HlsSource(long native_handle, Handler handler, Source.Listener listener) {
        this.native_source = native_handle;
        this.handler = handler;
        this.listener = listener;
    }

    public void handleLoad() {
        if (this.listener != null) {
            final HlsSource source = this;
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSource.this.listener.onLoad(source);
                }
            });
        }
    }

    public void handleError(int type, int code, String message) {
        if (this.listener != null) {
            ErrorType errorType = ErrorType.fromInt(type);
            final Source.LoadError err = new Source.LoadError(this.getId(), this.getUri().toString(), errorType, code, message);
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSource.this.listener.onError(err);
                }
            });
        }
    }

    @Override
    public synchronized String getId() {
        if (this.native_source != 0L) {
            return this.getId(this.native_source);
        }
        return "";
    }

    @Override
    public synchronized Uri getUri() {
        if (this.native_source != 0L) {
            return Uri.parse((String)this.getUri(this.native_source));
        }
        return Uri.EMPTY;
    }

    public synchronized String getManifest() {
        if (this.native_source != 0L) {
            return this.getManifest(this.native_source);
        }
        return "";
    }

    @Override
    @Nullable
    public synchronized String getSessionData(@NonNull String property) {
        if (this.native_source != 0L) {
            return this.getSessionData(this.native_source, property);
        }
        return null;
    }

    @Override
    @NonNull
    public synchronized Set<Quality> getQualities() {
        Set<Quality> result = this.getQualities(this.native_source);
        if (result == null) {
            return new HashSet<Quality>();
        }
        return result;
    }

    @Override
    @NonNull
    public synchronized Set<SourceGroup> getGroups() {
        Set<SourceGroup> result = this.getGroups(this.native_source);
        if (result == null) {
            return new HashSet<SourceGroup>();
        }
        return result;
    }

    @Override
    @NonNull
    public synchronized long getTimeToLive() {
        if (this.native_source != 0L) {
            return this.getTimeToLive(this.native_source);
        }
        return -1L;
    }

    public long handle() {
        return this.native_source;
    }

    @Override
    public synchronized void release() {
        if (this.native_source != 0L) {
            this.release(this.native_source);
            this.native_source = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.native_source != 0L) {
                Logging.e("Source not released, releasing from finalizer");
                this.release();
            }
        }
        finally {
            super.finalize();
        }
    }
}

