/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.amazonaws.ivs.player.EGLManager;
import com.amazonaws.ivs.player.HardwareInfo;

class HostInfoHelper {
    String packageName;
    int versionCode;
    String versionName;
    int targetSdkVersion;
    int minSdkVersion = -1;
    int compileSdkVersion = -1;
    boolean isLowMemoryDevice;
    String soc = "";
    String gpu = "";

    HostInfoHelper(Context context) {
        this.packageName = context.getPackageName();
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.packageName, 0);
            this.versionCode = pi.versionCode;
            this.versionName = pi.versionName;
        }
        catch (PackageManager.NameNotFoundException ignore) {
            this.versionName = "?";
        }
        ApplicationInfo ai = context.getApplicationInfo();
        this.targetSdkVersion = ai.targetSdkVersion;
        if (Build.VERSION.SDK_INT >= 24) {
            this.minSdkVersion = ai.minSdkVersion;
        }
        if (Build.VERSION.SDK_INT >= 31) {
            this.compileSdkVersion = ai.compileSdkVersion;
            this.soc = Build.SOC_MANUFACTURER + "_" + Build.SOC_MODEL;
        }
        EGLManager.create().ifOk(manager -> {
            HardwareInfo.create(context, manager).ifOk(hardwareInfo -> {
                this.gpu = hardwareInfo.getGPURenderer();
                hardwareInfo.release();
            });
            manager.release();
        });
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        this.isLowMemoryDevice = am.isLowRamDevice();
    }
}

