/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.os.Handler;
import android.os.Looper;
import com.amazonaws.ivs.player.Configurable;
import com.amazonaws.ivs.player.ConfigurationParser;
import com.amazonaws.ivs.player.DeviceConfigPropertyHolder;
import com.amazonaws.ivs.player.Experimental;
import org.json.JSONException;
import org.json.JSONObject;

abstract class IVSFeature<Config extends IVSConfig<Config>>
implements Configurable {
    final String key;
    final IVSConfig<Config> config;
    boolean isEnabled = !(this instanceof Experimental);
    private final Handler reporterHandler = Looper.myLooper() != null ? new Handler(Looper.myLooper()) : new Handler(Looper.getMainLooper());
    ErrorListener errorListener = null;
    EventListener eventListener = null;
    protected long nativeHandle = 0L;

    IVSFeature(String key, IVSConfig<Config> config) {
        this.key = key;
        this.config = config;
    }

    JSONObject overrideWithPayload(DeviceConfigPropertyHolder propertyHolder) throws JSONException {
        if (this.key.isEmpty()) {
            return null;
        }
        if (propertyHolder == null) {
            this.isEnabled = false;
            return null;
        }
        JSONObject properties = propertyHolder.getJsonObjectValue(this.key);
        if (properties == null) {
            this.isEnabled = false;
            return null;
        }
        JSONObject criteria = this.getCriteriaForFeature();
        String payloadBlob = this.getJsonPayloadFromCriteria(properties.toString(), criteria.toString());
        if (payloadBlob.isEmpty()) {
            this.isEnabled = false;
            return null;
        }
        JSONObject payload = new JSONObject(payloadBlob);
        this.overrideWith(payload);
        return payload;
    }

    void registerEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    void registerErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    JSONObject getCriteriaForFeature() throws JSONException {
        return new JSONObject();
    }

    private native String getJsonPayloadFromCriteria(String var1, String var2);

    long getNativeHandle() {
        return this.nativeHandle;
    }

    protected void reportError(RuntimeException exception) {
        if (this.errorListener != null) {
            this.reporterHandler.post(() -> this.errorListener.onError(exception));
        }
    }

    protected void reportAnalyticsEvent(Object event) {
        if (this.eventListener != null) {
            this.reporterHandler.post(() -> this.eventListener.onEvent(event));
        }
    }

    static interface ErrorListener {
        public void onError(Exception var1);

        public void onRecoverableError(Exception var1);
    }

    static interface EventListener {
        public void onEvent(Object var1);
    }

    public static abstract class IVSConfig<Impl extends IVSConfig<Impl>>
    implements ConfigurationParser.Encodable {
        Impl asImpl() {
            return (Impl)this;
        }

        @Override
        public void updateWithJson(JSONObject object) throws JSONException {
            ConfigurationParser.updateConfigurationFromJson(object, this.asImpl());
        }

        @Override
        public JSONObject toJson() throws JSONException {
            return ConfigurationParser.createJsonFromConfiguration(this.asImpl());
        }
    }
}

