/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Process;
import android.os.Trace;
import android.util.Range;
import android.view.Surface;
import com.amazonaws.ivs.player.DrmSession;
import com.amazonaws.ivs.player.ErrorType;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.MediaCodecFactory;
import com.amazonaws.ivs.player.MediaDecoder;
import com.amazonaws.ivs.player.MediaDecoderInfo;
import com.amazonaws.ivs.player.MediaRenderer;
import com.amazonaws.ivs.player.MediaSample;
import com.amazonaws.ivs.player.PlayerException;
import com.amazonaws.ivs.player.Size;
import com.amazonaws.ivs.player.SurfaceRenderer;
import com.amazonaws.ivs.player.VideoRenderer;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class MediaCodecDecoder
implements MediaDecoder,
VideoRenderer.SurfaceChangeListener {
    private static final Size SIZE_1080P = new Size(1920, 1080);
    private static final Size SIZE_1088P = new Size(1920, 1088);
    private static final Size SIZE_2160P = new Size(3840, 2160);
    private static final long DEQUE_TIMEOUT_US = TimeUnit.MILLISECONDS.toMicros(5L);
    private MediaFormat format;
    private MediaCodec codec;
    private String codecName;
    private final MediaRenderer renderer;
    private MediaCrypto mediaCrypto;
    private boolean rendererConfigured;
    private boolean hasSurface;
    private boolean supportsAdaptivePlayback;
    private boolean configured;
    private boolean isVideo;
    private boolean useSoftwareDecoder;
    private boolean reconfigureRetry;
    private boolean outputBufferEnabled;
    private boolean runOnEmulator;
    private ByteBuffer outputBuffer;
    private long reconfigureRetryTimeMillis;
    private long initialSampleTime;
    private MediaCodec.BufferInfo decodeInfo;
    private final Set<Long> decodeOnlyBuffers;
    private Size maxDecodeSize;
    private int inputBufferIndex;
    private int outputBufferIndex;
    private int queuedBufferCount;

    MediaCodecDecoder(MediaFormat format, MediaRenderer renderer) {
        this.renderer = renderer;
        this.format = format;
        this.decodeOnlyBuffers = new LinkedHashSet<Long>();
        this.resetDecodeInfo();
        if (renderer == null) {
            this.outputBufferEnabled = true;
        }
    }

    MediaCodecDecoder(MediaFormat format, SurfaceRenderer renderer) {
        this(format, (MediaRenderer)renderer);
        this.isVideo = true;
        this.maxDecodeSize = SIZE_1080P;
        this.runOnEmulator = Build.MODEL.startsWith("sdk") || "google_sdk".equals(Build.MODEL) || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK");
        renderer.setSurfaceChangeListener(this);
    }

    @Override
    public void configure(MediaFormat format) {
        Trace.beginSection((String)"MediaCodecDecoder configure");
        this.format = format;
        MediaCrypto crypto = null;
        DrmSession drmSession = DrmSession.get(format);
        MediaCrypto mediaCrypto = crypto = drmSession == null ? null : drmSession.getMediaCrypto(format);
        if (this.mediaCrypto != crypto) {
            this.mediaCrypto = crypto;
            this.releaseCodec();
        }
        if (this.codec == null) {
            this.createCodec();
        }
        if (!this.configured || this.runOnEmulator) {
            this.reconfigure();
        }
        Trace.endSection();
    }

    private void createCodec() {
        String mime = this.format.getString("mime");
        boolean requireSecureDecoder = this.mediaCrypto != null && this.mediaCrypto.requiresSecureDecoderComponent(mime);
        this.codec = this.isVideo && this.useSoftwareDecoder && !requireSecureDecoder ? MediaCodecFactory.createSoftwareCodec(mime) : MediaCodecFactory.createCodec(mime, requireSecureDecoder);
        if (this.codec == null) {
            throw new IllegalStateException("Failed to create codec instance " + mime);
        }
        this.codecName = this.codec.getName();
        Logging.i("decode " + mime + " using " + this.codecName);
        this.checkCodecCapabilities(mime);
    }

    private void reconfigure() {
        this.resetCodec();
        if (this.supportsAdaptivePlayback && this.isVideo && !this.runOnEmulator) {
            this.format.setInteger("max-width", this.maxDecodeSize.width);
            this.format.setInteger("max-height", this.maxDecodeSize.height);
        }
        try {
            Surface surface = this.isVideo ? ((VideoRenderer)this.renderer).getSurface() : null;
            this.codec.configure(this.format, surface, this.mediaCrypto, 0);
            this.hasSurface = surface != null;
            Logging.i("configured " + this.codecName + " format " + this.format);
            this.codec.start();
            this.configured = true;
        }
        catch (Exception e) {
            Logging.w(this.codecName + " configure failed", e);
            if (this.isVideo) {
                long currentTimeMillis;
                this.releaseCodec();
                if (!this.useSoftwareDecoder && e instanceof MediaCodec.CodecException) {
                    MediaCodec.CodecException ce = (MediaCodec.CodecException)e;
                    this.useSoftwareDecoder = Build.VERSION.SDK_INT >= 23 ? ce.getErrorCode() == 1100 : true;
                }
                if ((currentTimeMillis = System.currentTimeMillis()) - this.reconfigureRetryTimeMillis > 60000L) {
                    this.reconfigureRetry = false;
                    this.reconfigureRetryTimeMillis = currentTimeMillis;
                }
                if (!this.reconfigureRetry) {
                    this.reconfigureRetry = true;
                    this.createCodec();
                    this.reconfigure();
                    return;
                }
                throw new IllegalArgumentException("codecName:" + this.codecName + " surface: " + this.hasSurface + " maxDecodeSize:" + this.maxDecodeSize.toString() + " sap:" + this.supportsAdaptivePlayback + " format:" + this.format.toString() + " e:" + e);
            }
            throw e;
        }
    }

    private void checkCodecCapabilities(String mime) {
        if (this.isVideo) {
            this.maxDecodeSize = SIZE_1080P;
        }
        MediaCodecInfo.CodecCapabilities capabilities = null;
        try {
            capabilities = this.codec.getCodecInfo().getCapabilitiesForType(mime);
        }
        catch (IllegalArgumentException e) {
            Logging.e("Failed to get codec capabilities", e);
        }
        if (capabilities != null && this.isVideo) {
            Range range;
            this.supportsAdaptivePlayback = capabilities.isFeatureSupported("adaptive-playback");
            MediaCodecInfo.VideoCapabilities video = capabilities.getVideoCapabilities();
            if (video.getSupportedWidths().contains((Comparable)Integer.valueOf(MediaCodecDecoder.SIZE_2160P.width)) && (range = video.getSupportedHeightsFor(MediaCodecDecoder.SIZE_2160P.width)).contains((Comparable)Integer.valueOf(MediaCodecDecoder.SIZE_2160P.height))) {
                this.maxDecodeSize = SIZE_2160P;
            }
        }
        if (this.isVideo && MediaCodecFactory.limitMaxDecodeSize(this.codec.getName())) {
            this.maxDecodeSize = SIZE_1088P;
        }
    }

    @Override
    public boolean hasInput() {
        if (this.isVideo && !this.configured) {
            return true;
        }
        if (this.configured && this.codec != null) {
            try {
                Trace.beginSection((String)"MediaCodecDecoder hasInput");
                long timeout = this.queuedBufferCount > 0 ? DEQUE_TIMEOUT_US : 0L;
                this.inputBufferIndex = this.codec.dequeueInputBuffer(timeout);
            }
            catch (IllegalStateException e) {
                Logging.w(this.codecName + " MediaCodecDecoder dequeueInputBuffer failed", e);
                this.resetCodec();
            }
            finally {
                Trace.endSection();
            }
            return this.inputBufferIndex >= 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(MediaSample sample) {
        Trace.beginSection((String)("MediaCodecDecoder decode " + sample.presentationTimeUs));
        if (this.initialSampleTime <= 0L) {
            this.initialSampleTime = sample.decodeTimeUs;
        }
        if (this.isVideo) {
            VideoRenderer videoRenderer = (VideoRenderer)this.renderer;
            if (!this.configured) {
                if (!sample.isSyncSample || videoRenderer.getSurface() == null) {
                    this.configured = false;
                    return;
                }
                Logging.w("MediaCodecDecoder switching surface");
                this.releaseCodec();
                this.createCodec();
                this.reconfigure();
                videoRenderer.configure(this.format);
                try {
                    this.inputBufferIndex = this.codec.dequeueInputBuffer(-1L);
                }
                catch (Exception e) {
                    Logging.w(this.codecName + " MediaCodecDecoder dequeueInputBuffer failed", e);
                    this.resetCodec();
                }
            }
        }
        if (this.inputBufferIndex < 0) {
            throw new PlayerException(ErrorType.ERROR_INVALID_PARAMETER, "invalid buffer index");
        }
        try {
            this.queueInput(this.inputBufferIndex, sample);
        }
        catch (Exception e) {
            Logging.w(this.codecName + " MediaCodecDecoder queueInput failed", e);
            this.resetCodec();
        }
        finally {
            Trace.endSection();
        }
        this.inputBufferIndex = -1;
    }

    private void queueInput(int index, MediaSample sample) {
        ByteBuffer buffer = this.codec.getInputBuffer(index);
        buffer.put(sample.buffer);
        long presentationTimeUs = sample.presentationTimeUs - this.initialSampleTime;
        int flags = 0;
        if (sample.isSyncSample) {
            flags |= 1;
        }
        if (sample.cryptoInfo == null) {
            this.codec.queueInputBuffer(index, 0, sample.size, presentationTimeUs, flags);
        } else {
            this.codec.queueSecureInputBuffer(index, 0, sample.cryptoInfo, presentationTimeUs, flags);
        }
        ++this.queuedBufferCount;
        if (sample.isDecodeOnly) {
            this.decodeOnlyBuffers.add(sample.presentationTimeUs);
        }
    }

    private boolean dequeOutput(long timeoutUs) {
        this.outputBufferIndex = this.codec.dequeueOutputBuffer(this.decodeInfo, timeoutUs);
        if (this.outputBufferIndex >= 0) {
            boolean render;
            --this.queuedBufferCount;
            if ((this.decodeInfo.flags & 4) != 0) {
                Logging.d(this.codecName + " BUFFER_FLAG_END_OF_STREAM");
                this.resetCodec();
                return false;
            }
            long presentationTime = this.initialSampleTime + this.decodeInfo.presentationTimeUs;
            boolean bl = render = !this.decodeOnlyBuffers.contains(presentationTime);
            if (this.isVideo) {
                if (render && this.renderer != null) {
                    if (!this.rendererConfigured) {
                        try {
                            MediaFormat outputFormat = this.codec.getOutputFormat(this.outputBufferIndex);
                            this.configureRenderer(outputFormat);
                        }
                        catch (IllegalStateException e) {
                            Logging.d("Failed to get output format", e);
                            this.rendererConfigured = true;
                            this.configureRenderer(this.format);
                        }
                    }
                    VideoRenderer videoRenderer = (VideoRenderer)this.renderer;
                    videoRenderer.render(this.codec, this.outputBufferIndex, presentationTime);
                    return this.inputBufferIndex < 0;
                }
                this.codec.releaseOutputBuffer(this.outputBufferIndex, false);
            } else {
                if (this.outputBufferEnabled) {
                    return true;
                }
                ByteBuffer output = this.codec.getOutputBuffer(this.outputBufferIndex);
                if (render && this.renderer != null && this.rendererConfigured) {
                    this.renderer.render(output, this.decodeInfo.size, presentationTime);
                }
                this.codec.releaseOutputBuffer(this.outputBufferIndex, false);
            }
        } else {
            if (this.outputBufferIndex == -2) {
                Logging.d(this.codecName + " INFO_OUTPUT_FORMAT_CHANGED");
                this.configureRenderer(this.codec.getOutputFormat());
                return true;
            }
            if (this.outputBufferIndex == -3) {
                Logging.d(this.codecName + " INFO_OUTPUT_BUFFERS_CHANGED");
                return true;
            }
        }
        return false;
    }

    @Override
    public void flush() {
        if (this.codec == null || !this.configured) {
            return;
        }
        Trace.beginSection((String)("MediaCodecDecoder flush adaptive=" + this.supportsAdaptivePlayback));
        if (!this.supportsAdaptivePlayback) {
            if (this.queuedBufferCount == 0) {
                Logging.w(this.codecName + " no buffers queued on flush");
                this.resetCodec();
                return;
            }
            int index = -1;
            while (index < 0) {
                index = this.codec.dequeueInputBuffer(DEQUE_TIMEOUT_US);
                if (index < 0) {
                    Logging.w(this.codecName + " wait to queue EOS");
                    this.dequeOutput(0L);
                    continue;
                }
                Logging.i(this.codecName + " queue BUFFER_FLAG_END_OF_STREAM");
                this.codec.queueInputBuffer(index, 0, 0, 0L, 4);
            }
            while (this.configured) {
                this.dequeOutput(0L);
            }
        }
        Trace.endSection();
    }

    @Override
    public void release() {
        Trace.beginSection((String)"MediaCodecDecoder release");
        this.releaseCodec();
        Trace.endSection();
    }

    @Override
    public void reset() {
        Trace.beginSection((String)"MediaCodecDecoder reset");
        this.initialSampleTime = 0L;
        this.resetDecodeInfo();
        if (this.codec != null && this.configured) {
            if (!this.supportsAdaptivePlayback) {
                this.resetCodec();
            } else {
                try {
                    this.codec.flush();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    this.resetCodec();
                }
            }
        }
        Trace.endSection();
    }

    @Override
    public boolean hasOutput() {
        try {
            Trace.beginSection((String)"MediaCodecDecoder hasOutput");
            boolean bl = this.configured && this.dequeOutput(0L) && this.renderer.shouldProcessMore();
            return bl;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            Logging.w(this.codecName + " MediaCodecDecoder dequeOutput failed", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Trace.endSection();
        }
    }

    @Override
    public ByteBuffer getOutput() {
        if (this.outputBufferEnabled && this.outputBufferIndex >= 0) {
            Trace.beginSection((String)"MediaCodecDecoder getOutput");
            ByteBuffer output = this.codec.getOutputBuffer(this.outputBufferIndex);
            if (this.outputBuffer == null || this.outputBuffer.capacity() < output.capacity()) {
                this.outputBuffer = ByteBuffer.allocateDirect(output.capacity());
            }
            this.outputBuffer.clear();
            this.outputBuffer.put(output).flip().limit(this.decodeInfo.size);
            this.codec.releaseOutputBuffer(this.outputBufferIndex, false);
            this.outputBufferIndex = -1;
            Trace.endSection();
            return this.outputBuffer;
        }
        return null;
    }

    @Override
    public long getOutputTime() {
        return this.initialSampleTime + this.decodeInfo.presentationTimeUs;
    }

    @Override
    public void onSurfaceChange(Surface surface) {
        if (this.configured && this.codec != null) {
            if (Build.VERSION.SDK_INT >= 23 && this.hasSurface && surface != null) {
                this.codec.setOutputSurface(surface);
            } else {
                this.releaseCodec();
            }
        }
    }

    private void configureRenderer(MediaFormat format) {
        if (this.renderer != null) {
            this.renderer.configure(format);
            this.rendererConfigured = true;
        }
    }

    private void resetCodec() {
        if (this.codec != null) {
            this.codec.reset();
        }
        this.configured = false;
        this.hasSurface = false;
    }

    private void releaseCodec() {
        Logging.d("releaseCodec " + this.codec);
        this.resetDecodeInfo();
        if (this.codec != null) {
            new CodecReleaseThread(this.codec).start();
            this.codec = null;
        }
        this.configured = false;
        this.hasSurface = false;
    }

    private void resetDecodeInfo() {
        this.decodeOnlyBuffers.clear();
        this.decodeInfo = new MediaCodec.BufferInfo();
        this.queuedBufferCount = 0;
        this.inputBufferIndex = -1;
        this.outputBufferIndex = -1;
    }

    @Override
    public MediaDecoderInfo getInfo() {
        if (this.codec == null) {
            return null;
        }
        return new MediaDecoderInfo(this.codec);
    }

    class CodecReleaseThread
    extends Thread {
        private final MediaCodec codecToRelease;

        public CodecReleaseThread(MediaCodec codec) {
            this.codecToRelease = codec;
        }

        @Override
        public void run() {
            if (this.codecToRelease != null) {
                Logging.d("CodecReleaseThread start " + this.codecToRelease);
                try {
                    Process.setThreadPriority((int)-2);
                }
                catch (Exception e) {
                    Logging.i("Error while setting thread priority", e);
                }
                try {
                    this.codecToRelease.stop();
                }
                catch (Exception e) {
                    Logging.w("Codec stop() failed", e);
                }
                finally {
                    try {
                        this.codecToRelease.release();
                    }
                    catch (Exception e) {
                        Logging.w("Codec release() failed", e);
                    }
                }
                Logging.d("CodecReleaseThread end");
            }
        }
    }
}

