/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import com.amazonaws.ivs.player.Logging;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class MediaCodecFactory {
    static final String OMX_SOFTWARE_AVC_DECODER = "OMX.google.h264.decoder";
    static final String OMX_SOFTWARE_VP9_DECODER = "OMX.google.vp9.decoder";
    static final String OMX_SOFTWARE_AV1_DECODER = "c2.android.av1.decoder";
    static final String OMX_SOFTWARE_HEVC_DECODER = "OMX.google.hevc.decoder";

    private MediaCodecFactory() {
    }

    static MediaCodec createCodec(String mediaType, boolean secure) {
        String codecName = MediaCodecFactory.findDecoder(mediaType, secure);
        MediaCodec codec = null;
        if (codecName == null) {
            try {
                codec = MediaCodec.createDecoderByType((String)mediaType);
            }
            catch (IOException e) {
                Logging.w("Failed to create codec " + mediaType, e);
            }
        } else {
            codec = MediaCodecFactory.createCodecByName(codecName);
        }
        if (codec == null && secure && (codecName = MediaCodecFactory.findDecoder(mediaType, false)) != null) {
            codec = MediaCodecFactory.createCodecByName(codecName + ".secure");
        }
        return codec;
    }

    private static MediaCodec createCodecByName(String name) {
        if (name != null) {
            try {
                return MediaCodec.createByCodecName((String)name);
            }
            catch (MediaCodec.CodecException | IOException e) {
                Logging.w("Failed to create codec " + name, e);
            }
        }
        return null;
    }

    static MediaCodec createSoftwareCodec(String mediaType) {
        switch (mediaType) {
            case "video/avc": {
                return MediaCodecFactory.createCodecByName(OMX_SOFTWARE_AVC_DECODER);
            }
            case "video/x-vnd.on2.vp9": {
                return MediaCodecFactory.createCodecByName(OMX_SOFTWARE_VP9_DECODER);
            }
            case "video/av01": {
                return MediaCodecFactory.createCodecByName(OMX_SOFTWARE_AV1_DECODER);
            }
            case "video/hevc": {
                return MediaCodecFactory.createCodecByName(OMX_SOFTWARE_HEVC_DECODER);
            }
        }
        return null;
    }

    static String findDecoder(String mime, boolean secure) {
        List<MediaCodecInfo> supported = MediaCodecFactory.findSupportedCodecs(mime, secure);
        if (!supported.isEmpty()) {
            MediaCodecInfo info = supported.get(0);
            return info.getName();
        }
        return null;
    }

    static List<MediaCodecInfo> findSupportedCodecs(String mime, boolean secure) {
        ArrayList<MediaCodecInfo> supported = new ArrayList<MediaCodecInfo>();
        int kind = secure ? 1 : 0;
        MediaCodecList list = new MediaCodecList(kind);
        for (MediaCodecInfo info : list.getCodecInfos()) {
            MediaCodecInfo.CodecCapabilities capabilities;
            boolean isSupported;
            if (info.isEncoder() || !MediaCodecFactory.supportsType(info, mime)) continue;
            boolean bl = isSupported = !secure;
            if (secure && (capabilities = info.getCapabilitiesForType(mime)).isFeatureSupported("secure-playback")) {
                isSupported = true;
            }
            if (!isSupported) continue;
            supported.add(info);
        }
        return supported;
    }

    private static boolean supportsType(MediaCodecInfo info, String mime) {
        String[] types;
        for (String type : types = info.getSupportedTypes()) {
            if (!type.equalsIgnoreCase(mime)) continue;
            return true;
        }
        return false;
    }

    static boolean limitMaxDecodeSize(String codecName) {
        return "OMX.amlogic.avc.decoder.awesome".equals(codecName);
    }
}

