/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.amazonaws.ivs.experiments.ExperimentData;
import com.amazonaws.ivs.player.Configuration;
import com.amazonaws.ivs.player.CorePlayerImpl;
import com.amazonaws.ivs.player.Experiments;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.Player;
import com.amazonaws.ivs.player.PlayerInternal;
import com.amazonaws.ivs.player.SessionConfig;
import java.util.Map;

public interface MediaPlayer
extends Player,
PlayerInternal {
    public static Map<String, String> getExperimentEntries() {
        return Experiments.getEntries();
    }

    public static class LoadOptions {
        private final Uri uri;
        private String mediaType = "";
        private SessionConfig sessionConfig = new SessionConfig();

        public LoadOptions(@NonNull Uri uri) {
            this.uri = uri;
        }

        public LoadOptions setMediaType(@NonNull String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public LoadOptions setSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.sessionConfig = sessionConfig;
            return this;
        }

        Uri getUri() {
            return this.uri;
        }

        String getMediaType() {
            return this.mediaType;
        }

        SessionConfig getSessionConfig() {
            return this.sessionConfig;
        }
    }

    public static final class Builder {
        private final Context context;
        private Experiments experiments;
        private Configuration configuration;
        private ExperimentData[] experimentData;

        public Builder(Context context) {
            this.context = context;
            this.experiments = new Experiments();
            this.configuration = new Configuration();
        }

        public Builder experiments(ExperimentData[] data) {
            this.experimentData = data;
            this.experiments.setExperiments(data);
            return this;
        }

        public Builder sessionConfig(SessionConfig sessionConfig) {
            this.configuration.overrideWith(sessionConfig);
            return this;
        }

        public MediaPlayer build() {
            this.configuration.overrideWith(this.experiments);
            Logging.d("Creating player with config: " + this.configuration);
            CorePlayerImpl player = new CorePlayerImpl(this.context, this.configuration);
            player.setExperiments(this.experimentData);
            return player;
        }
    }
}

