/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.media.MediaCodec;
import java.nio.ByteBuffer;

class MediaSample {
    public final ByteBuffer buffer;
    public final int size;
    public final long decodeTimeUs;
    public final long presentationTimeUs;
    public final long durationUs;
    public final boolean isSyncSample;
    public final boolean isDecodeOnly;
    public final MediaCodec.CryptoInfo cryptoInfo;

    MediaSample(ByteBuffer buffer, int size, long decodeTimeUs, long presentationTimeUs, long durationUs, boolean isSyncSample, boolean isDecodeOnly) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
        this.size = size;
        this.decodeTimeUs = decodeTimeUs;
        this.presentationTimeUs = presentationTimeUs;
        this.durationUs = durationUs;
        this.isSyncSample = isSyncSample;
        this.isDecodeOnly = isDecodeOnly;
        this.cryptoInfo = null;
    }

    MediaSample(ByteBuffer buffer, int size, long decodeTimeUs, long presentationTimeUs, long durationUs, boolean isSyncSample, boolean isDecodeOnly, byte[] initializationVector, byte[] keyId, int[] bytesOfClearData, int[] bytesOfEncryptedData, int subsampleCount, int cipherMode) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        if (initializationVector == null || initializationVector.length == 0) {
            throw new IllegalArgumentException("Invalid initialization vector");
        }
        if (keyId == null || keyId.length == 0) {
            throw new IllegalArgumentException("Invalid key id");
        }
        this.buffer = buffer;
        this.size = size;
        this.decodeTimeUs = decodeTimeUs;
        this.presentationTimeUs = presentationTimeUs;
        this.durationUs = durationUs;
        this.isSyncSample = isSyncSample;
        this.isDecodeOnly = isDecodeOnly;
        this.cryptoInfo = new MediaCodec.CryptoInfo();
        this.cryptoInfo.iv = initializationVector;
        this.cryptoInfo.key = keyId;
        this.cryptoInfo.numBytesOfClearData = bytesOfClearData;
        this.cryptoInfo.numBytesOfEncryptedData = bytesOfEncryptedData;
        this.cryptoInfo.numSubSamples = subsampleCount;
        this.cryptoInfo.mode = cipherMode;
    }

    public String toString() {
        return "Sample: , size=" + this.size + ", decodeTimeUs=" + this.decodeTimeUs + ", presentationTimeUs=" + this.presentationTimeUs + ", durationUs=" + this.durationUs + ", isSyncSample=" + this.isSyncSample + ", isDecodeOnly=" + this.isDecodeOnly + ", cryptoInfo=" + (this.cryptoInfo == null ? "" : this.cryptoInfo.toString());
    }
}

