/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import java.util.HashMap;

class Performance {
    Performance() {
    }

    static class Snapshot {
        private int numMeasurements = 0;
        private float meanMeasurement = 0.0f;

        Snapshot() {
        }

        float time() {
            return this.meanMeasurement / 1000000.0f;
        }

        int samples() {
            return this.numMeasurements;
        }

        private void reset() {
            this.numMeasurements = 0;
            this.meanMeasurement = 0.0f;
        }
    }

    static class Trackable
    implements AutoCloseable {
        private final Snapshot snapshot = new Snapshot();
        private long startTime;

        Trackable() {
        }

        Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        public void close() {
            this.update(System.nanoTime() - this.startTime);
        }

        private void setStartTime() {
            this.startTime = System.nanoTime();
        }

        private void update(long measurement) {
            ++this.snapshot.numMeasurements;
            this.snapshot.meanMeasurement += ((float)measurement - this.snapshot.meanMeasurement) / (float)this.snapshot.numMeasurements;
        }

        private void reset() {
            this.snapshot.reset();
        }
    }

    static class Monitor {
        private final HashMap<String, Trackable> trackables = new HashMap();

        Monitor() {
        }

        Snapshot getSnapshot(String description) {
            Trackable trackable = this.trackables.get(description);
            if (trackable != null) {
                return trackable.getSnapshot();
            }
            return new Snapshot();
        }

        Trackable time(String description) {
            Trackable trackable = this.trackables.get(description);
            if (trackable == null) {
                trackable = new Trackable();
                this.trackables.put(description, trackable);
            }
            trackable.setStartTime();
            return trackable;
        }

        void reset(String description) {
            Trackable trackable = this.trackables.get(description);
            if (trackable != null) {
                trackable.reset();
            }
        }
    }
}

