/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.content.Context;
import android.net.Uri;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazonaws.ivs.player.Cue;
import com.amazonaws.ivs.player.MediaPlayer;
import com.amazonaws.ivs.player.PlayerException;
import com.amazonaws.ivs.player.Quality;
import com.amazonaws.ivs.player.Releasable;
import com.amazonaws.ivs.player.SeiMessage;
import com.amazonaws.ivs.player.SourceGroup;
import com.amazonaws.ivs.player.Statistics;
import com.amazonaws.ivs.player.UnavailableQuality;
import java.nio.ByteBuffer;
import java.util.Set;

public interface Player
extends Releasable {
    @Override
    public void release();

    public int getAudioSessionId();

    @NonNull
    public State getState();

    public long getPosition();

    public long getSyncTime();

    public long getDuration();

    public long getBufferedPosition();

    @NonNull
    public String getVersion();

    public void addListener(@NonNull Listener var1);

    public void removeListener(@NonNull Listener var1);

    public void setLooping(boolean var1);

    public boolean isMuted();

    public void setMuted(boolean var1);

    public void setSurface(@Nullable Surface var1);

    public float getPlaybackRate();

    public void setPlaybackRate(float var1);

    public void setVolume(float var1);

    public float getVolume();

    public void load(@NonNull Uri var1);

    public void load(@NonNull Uri var1, @NonNull String var2);

    public void seekTo(long var1);

    public void play();

    public void pause();

    @NonNull
    public Set<Quality> getQualities();

    @NonNull
    public Quality getQuality();

    public void setQuality(@NonNull Quality var1);

    public void setQuality(@NonNull Quality var1, boolean var2);

    public boolean isAutoQualityMode();

    public void setAutoQualityMode(boolean var1);

    public void setAutoInitialBitrate(int var1);

    public void setAutoMaxBitrate(int var1);

    public void setAutoMaxVideoSize(int var1, int var2);

    public void setAutoMaxQuality(@NonNull Quality var1);

    public boolean isLiveLowLatency();

    public void setLiveLowLatencyEnabled(boolean var1);

    public void setRebufferToLive(boolean var1);

    public long getAverageBitrate();

    public long getBandwidthEstimate();

    public long getLiveLatency();

    @NonNull
    public Statistics getStatistics();

    @NonNull
    public String getSessionId();

    @NonNull
    public String[] getChannelMetadata();

    @NonNull
    public Set<UnavailableQuality> getUnavailableQualities();

    public void setLogLevel(@NonNull LogLevel var1);

    public void setInitialBufferDuration(long var1);

    public void setOrigin(@NonNull String var1);

    public void setNetworkRecoveryMode(NetworkRecoveryMode var1);

    public String getPath();

    public static enum NetworkRecoveryMode {
        NONE,
        RESUME;

    }

    public static enum LogLevel {
        DEBUG(3),
        INFO(4),
        WARNING(5),
        ERROR(6);

        private final int systemLogLevel;

        private LogLevel(int level) {
            this.systemLogLevel = level;
        }

        int systemLogLevel() {
            return this.systemLogLevel;
        }
    }

    public static abstract class Listener {
        public void onAnalyticsEvent(@NonNull String name, @NonNull String properties) {
        }

        public abstract void onCue(@NonNull Cue var1);

        public void onSeiMessage(@NonNull SeiMessage seiMessage) {
        }

        public abstract void onDurationChanged(long var1);

        public abstract void onStateChanged(@NonNull State var1);

        public abstract void onError(@NonNull PlayerException var1);

        public abstract void onRebuffering();

        public abstract void onSeekCompleted(long var1);

        public abstract void onVideoSizeChanged(int var1, int var2);

        public abstract void onQualityChanged(@NonNull Quality var1);

        public void onSourceGroupChanged(@NonNull SourceGroup sourceGroup) {
        }

        public void onMetadata(@NonNull String mediaType, @NonNull ByteBuffer data) {
        }

        public void onNetworkUnavailable() {
        }

        public void onVideoFirstFrame(long time) {
        }

        public void onSyncTimeChanged(long syncTime) {
        }
    }

    public static class Factory {
        private Factory() {
        }

        @NonNull
        public static Player create(@NonNull Context context) {
            return new MediaPlayer.Builder(context).build();
        }
    }

    public static enum State {
        BUFFERING,
        PLAYING,
        READY,
        IDLE,
        ENDED;

    }
}

