/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazonaws.ivs.player.Player;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class PlayerControlView
extends LinearLayout
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    private SeekBar seekBar;
    private TextView positionText;
    private TextView durationText;
    private ImageButton playPauseButton;
    private Player player;
    private Handler visibilityHandler;
    private Handler positionHandler;

    public PlayerControlView(@NonNull Context context) {
        super(context);
        this.initialize();
    }

    public PlayerControlView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    public PlayerControlView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    @NonNull
    public SeekBar getSeekBar() {
        return this.seekBar;
    }

    @NonNull
    public TextView getPositionTextView() {
        return this.positionText;
    }

    @NonNull
    public TextView getDurationTextView() {
        return this.durationText;
    }

    @NonNull
    public ImageButton getPlayButton() {
        return this.playPauseButton;
    }

    private void initialize() {
        this.setOrientation(1);
        this.setBackgroundColor(-16777216);
        this.getBackground().setAlpha(200);
        this.visibilityHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                PlayerControlView.this.setVisibility(msg.what);
                return true;
            }
        });
        this.positionHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                PlayerControlView.this.updateControls();
                return false;
            }
        });
        this.seekBar = new SeekBar(this.getContext());
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.positionText = new TextView(this.getContext());
        this.durationText = new TextView(this.getContext());
        if (Build.VERSION.SDK_INT >= 23) {
            this.positionText.setTextAppearance(16974257);
            this.durationText.setTextAppearance(16974257);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.playPauseButton = new ImageButton(this.getContext());
        this.playPauseButton.setOnClickListener((View.OnClickListener)this);
        this.playPauseButton.setBackground(null);
        this.addView((View)this.playPauseButton, (ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(-1, -2);
        params.gravity = 17;
        this.addView((View)this.initializeTimeline(), (ViewGroup.LayoutParams)params);
        this.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                PlayerControlView.this.updateControls();
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
    }

    private LinearLayout initializeTimeline() {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(0);
        int pad = (int)TypedValue.applyDimension((int)2, (float)10.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        linearLayout.setPadding(pad, pad, 0, pad * 3);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 8388627;
        linearLayout.addView((View)this.positionText, (ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(-1, -2);
        params.gravity = 17;
        params.weight = 1.0f;
        params.setMargins(pad, pad, pad, pad);
        linearLayout.addView((View)this.seekBar, (ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 8388629;
        linearLayout.addView((View)this.durationText, (ViewGroup.LayoutParams)params);
        return linearLayout;
    }

    public void setPlayer(@NonNull Player player) {
        this.player = player;
        this.updateControls();
    }

    private void updateControls() {
        if (this.player == null) {
            return;
        }
        long duration = this.player.getDuration();
        long position = this.player.getPosition();
        if (duration == -1L) {
            this.seekBar.setVisibility(4);
            this.durationText.setVisibility(4);
        } else {
            this.seekBar.setVisibility(0);
            this.seekBar.setMax((int)duration);
            this.seekBar.setProgress((int)position);
            this.durationText.setVisibility(0);
            this.durationText.setText((CharSequence)PlayerControlView.getDurationString(duration));
        }
        this.positionText.setText((CharSequence)PlayerControlView.getDurationString(position));
        Player.State state = this.player.getState();
        if (state == Player.State.PLAYING) {
            this.playPauseButton.setImageResource(17301539);
        } else if (state == Player.State.IDLE || state == Player.State.ENDED) {
            this.playPauseButton.setImageResource(17301540);
        }
        if (this.isAttachedToWindow()) {
            this.positionHandler.removeMessages(0);
            this.positionHandler.sendEmptyMessageDelayed(0, 200L);
        }
    }

    private static String getDurationString(long milliseconds) {
        long time = milliseconds;
        long hours = TimeUnit.MILLISECONDS.toHours(time);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(time -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(time -= TimeUnit.MINUTES.toMillis(minutes));
        time -= TimeUnit.SECONDS.toMillis(seconds);
        StringBuilder sb = new StringBuilder();
        if (hours > 0L) {
            sb.append(String.format(Locale.getDefault(), "%02d", hours));
            sb.append(":");
        }
        sb.append(String.format(Locale.getDefault(), "%02d", minutes));
        sb.append(":");
        sb.append(String.format(Locale.getDefault(), "%02d", seconds));
        return sb.toString();
    }

    public void showControls(boolean show) {
        this.visibilityHandler.removeMessages(4);
        this.visibilityHandler.removeMessages(0);
        if (show) {
            this.setVisibility(0);
            Message message = this.visibilityHandler.obtainMessage(4);
            this.visibilityHandler.sendMessageDelayed(message, 5000L);
        } else {
            this.setVisibility(4);
        }
    }

    public void onClick(View v) {
        if (this.player != null) {
            Player.State state = this.player.getState();
            if (state == Player.State.PLAYING || state == Player.State.BUFFERING) {
                this.player.pause();
            } else {
                this.player.play();
            }
        }
        this.showControls(true);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        long duration;
        if (this.player != null && fromUser && (duration = this.player.getDuration()) > 0L && (long)progress <= duration) {
            this.player.seekTo(progress);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.showControls(true);
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }
}

