/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import androidx.annotation.NonNull;
import com.amazonaws.ivs.player.ErrorType;

public class PlayerException
extends RuntimeException {
    private final String source;
    private final ErrorType errorType;
    private final int code;
    private final String message;

    PlayerException(ErrorType errorType, String message) {
        this(null, "Unspecified", errorType, 0, message);
    }

    PlayerException(String source, ErrorType errorType, int code, String message) {
        this(null, source, errorType, code, message);
    }

    PlayerException(Throwable cause, String source, ErrorType errorType, int code, String message) {
        super(PlayerException.constructMessage(cause, source, errorType, code, message), cause);
        this.source = source == null ? "Unspecified" : source;
        this.errorType = errorType == null ? ErrorType.ERROR : errorType;
        this.code = code;
        this.message = message == null ? "" : message;
    }

    private static String constructMessage(Throwable cause, String source, ErrorType errorType, int code, String message) {
        String delimiter = " : ";
        StringBuilder sb = new StringBuilder();
        if (source != null && !"Unspecified".equals(source)) {
            sb.append(source).append(delimiter);
        }
        if (errorType != null) {
            sb.append((Object)errorType).append(delimiter);
        }
        if (code != 0) {
            sb.append(code).append(delimiter);
        }
        if (message != null) {
            sb.append(message);
        }
        if (cause != null) {
            sb.append(" (").append(cause).append(")");
        }
        return sb.toString();
    }

    public int getCode() {
        return this.code;
    }

    @NonNull
    public String getSource() {
        return this.source;
    }

    @NonNull
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @NonNull
    public String getErrorMessage() {
        return this.message;
    }
}

