/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Typeface;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazonaws.ivs.player.AudioFocusHandler;
import com.amazonaws.ivs.player.Configuration;
import com.amazonaws.ivs.player.Cue;
import com.amazonaws.ivs.player.Player;
import com.amazonaws.ivs.player.PlayerControlView;
import com.amazonaws.ivs.player.PlayerException;
import com.amazonaws.ivs.player.PlayerInternal;
import com.amazonaws.ivs.player.Quality;
import com.amazonaws.ivs.player.ResizeMode;
import com.amazonaws.ivs.player.SourceGroup;
import com.amazonaws.ivs.player.TextCue;
import java.nio.ByteBuffer;

public class PlayerView
extends FrameLayout
implements SurfaceHolder.Callback,
View.OnAttachStateChangeListener {
    private Player player;
    private SurfaceView surfaceView;
    private Surface surface;
    private TextView captionsView;
    private PlayerControlView controlsView;
    private AudioFocusHandler audioFocusHandler;
    private boolean captionsEnabled;
    private boolean controlsEnabled;
    private ProgressBar progressView;
    private Uri mediaUri;
    private ResizeMode resizeMode;
    private int videoWidth;
    private int videoHeight;
    private final Player.Listener playerListener = new Player.Listener(){

        @Override
        public void onAnalyticsEvent(@NonNull String name, @NonNull String properties) {
        }

        @Override
        public void onCue(@NonNull Cue cue) {
            if (cue instanceof TextCue && PlayerView.this.captionsEnabled) {
                PlayerView.this.captionsView.setText((CharSequence)((TextCue)cue).text);
            }
        }

        @Override
        public void onStateChanged(@NonNull Player.State state) {
            switch (state) {
                case BUFFERING: {
                    PlayerView.this.progressView.setVisibility(0);
                    break;
                }
                case READY: {
                    PlayerView.this.captionsView.setText((CharSequence)"");
                    PlayerView.this.player.play();
                    PlayerView.this.progressView.setVisibility(4);
                    break;
                }
                case IDLE: {
                    PlayerView.this.progressView.setVisibility(4);
                    break;
                }
                case PLAYING: {
                    PlayerView.this.progressView.setVisibility(4);
                    PlayerView.this.audioFocusHandler.requestFocus();
                    break;
                }
                case ENDED: {
                    PlayerView.this.captionsView.setText((CharSequence)"");
                    PlayerView.this.progressView.setVisibility(4);
                    PlayerView.this.audioFocusHandler.abandonFocus();
                }
            }
        }

        @Override
        public void onDurationChanged(long duration) {
        }

        @Override
        public void onError(@NonNull PlayerException exception) {
        }

        @Override
        public void onRebuffering() {
        }

        @Override
        public void onSeekCompleted(long time) {
        }

        @Override
        public void onVideoSizeChanged(int width, int height) {
            PlayerView.this.videoWidth = width;
            PlayerView.this.videoHeight = height;
            PlayerView.this.resizeMode.setLayoutParams(PlayerView.this.surfaceView, width, height);
        }

        @Override
        public void onQualityChanged(@NonNull Quality quality) {
        }

        @Override
        public void onSourceGroupChanged(@NonNull SourceGroup group) {
        }

        @Override
        public void onMetadata(@NonNull String mediaType, @NonNull ByteBuffer data) {
        }
    };

    public PlayerView(@NonNull Context context) {
        super(context);
        this.initialize();
    }

    public PlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    public PlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    private void initialize() {
        this.controlsEnabled = true;
        this.audioFocusHandler = new AudioFocusHandler(this.getContext());
        this.resizeMode = ResizeMode.FIT;
        this.surfaceView = new SurfaceView(this.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        params.gravity = 17;
        this.addView((View)this.surfaceView, (ViewGroup.LayoutParams)params);
        this.surfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.captionsView = new TextView(this.getContext());
        this.captionsView.setBackgroundColor(-16777216);
        this.captionsView.setTypeface(Typeface.MONOSPACE);
        this.captionsView.setTextSize(2, 24.0f);
        this.captionsView.setTextAlignment(4);
        params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 81;
        this.addView((View)this.captionsView, (ViewGroup.LayoutParams)params);
        this.progressView = new ProgressBar(this.getContext());
        this.progressView.setIndeterminate(true);
        this.progressView.setVisibility(4);
        params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.addView((View)this.progressView, (ViewGroup.LayoutParams)params);
        this.controlsView = new PlayerControlView(this.getContext());
        params = new FrameLayout.LayoutParams(-1, -2);
        params.gravity = 80;
        this.addView((View)this.controlsView, (ViewGroup.LayoutParams)params);
        Player player = Player.Factory.create(this.getContext());
        this.setPlayer(player);
        this.addOnAttachStateChangeListener(this);
    }

    @NonNull
    public Player getPlayer() {
        return this.player;
    }

    private void setPlayer(@NonNull Player player) {
        if (this.player != null) {
            this.player.release();
        }
        this.player = player;
        player.addListener(this.playerListener);
        this.controlsView.setPlayer(player);
    }

    @NonNull
    public PlayerControlView getControls() {
        return this.controlsView;
    }

    public boolean getCaptionsEnabled() {
        return this.captionsEnabled;
    }

    public void setCaptionsEnabled(boolean enabled) {
        this.captionsEnabled = enabled;
        this.captionsView.setVisibility(enabled ? 0 : 8);
    }

    public boolean getControlsEnabled() {
        return this.controlsEnabled;
    }

    public void setControlsEnabled(boolean enabled) {
        this.controlsEnabled = enabled;
        if (this.controlsEnabled) {
            this.controlsView.setVisibility(0);
        } else {
            this.controlsView.setVisibility(4);
        }
    }

    public Uri getMediaUri() {
        return this.mediaUri;
    }

    public void setMediaUri(Uri mediaUri) {
        this.mediaUri = mediaUri;
        if (this.player != null) {
            this.player.load(mediaUri);
        }
    }

    @NonNull
    public ResizeMode getResizeMode() {
        return this.resizeMode;
    }

    public void setResizeMode(@NonNull ResizeMode mode) {
        this.resizeMode = mode;
        if (this.videoWidth > 0 && this.videoHeight > 0) {
            this.resizeMode.setLayoutParams(this.surfaceView, this.videoWidth, this.videoHeight);
        }
    }

    public int getVolumeControlStream() {
        return this.audioFocusHandler.getVolumeControlStream();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = super.onTouchEvent(event);
        if (!handled && this.controlsEnabled) {
            this.controlsView.showControls(true);
        }
        return handled;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.player != null) {
            if (keyCode == 126) {
                this.player.play();
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                this.player.pause();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.surface = holder.getSurface();
        if (this.player != null) {
            this.player.setSurface(this.surface);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Configuration config;
        boolean surfaceSizeFilterEnabled;
        if (this.player != null && this.player instanceof PlayerInternal && (surfaceSizeFilterEnabled = (config = ((PlayerInternal)((Object)this.player)).getConfiguration()).getBoolean(Configuration.Group.ADAPTIVE_BITRATE, "surfaceSizeFilterEnabled"))) {
            ((PlayerInternal)((Object)this.player)).setSurfaceSize(width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.surface = null;
        if (this.player != null) {
            this.player.setSurface(null);
        }
    }

    public void onViewAttachedToWindow(View v) {
        if (this.mediaUri != null) {
            this.player.load(this.mediaUri);
            this.player.play();
        }
        if (this.surface != null) {
            this.player.setSurface(this.surface);
        }
    }

    public void onViewDetachedFromWindow(View v) {
        this.progressView.setVisibility(4);
        this.audioFocusHandler.abandonFocus();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.surfaceView.post(new Runnable(){

                @Override
                public void run() {
                    if (PlayerView.this.videoWidth > 0 && PlayerView.this.videoHeight > 0) {
                        PlayerView.this.resizeMode.setLayoutParams(PlayerView.this.surfaceView, PlayerView.this.videoWidth, PlayerView.this.videoHeight);
                    }
                }
            });
        }
    }
}

