/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.media.MediaDrm;
import java.util.EnumSet;
import java.util.UUID;

public enum ProtectionSystem {
    WIDEVINE(UUID.fromString("edef8ba9-79d6-4ace-a3c8-27dcd51d21ed")),
    PLAYREADY(UUID.fromString("9a04f079-9840-4286-ab92-e65be0885f95"));

    private final UUID uuid;
    private static final EnumSet<ProtectionSystem> supported;

    private ProtectionSystem(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnumSet<ProtectionSystem> getSupported() {
        EnumSet<ProtectionSystem> enumSet = supported;
        synchronized (enumSet) {
            if (supported.isEmpty()) {
                for (ProtectionSystem scheme : ProtectionSystem.values()) {
                    if (!MediaDrm.isCryptoSchemeSupported((UUID)scheme.getUUID())) continue;
                    supported.add(scheme);
                }
            }
        }
        return supported;
    }

    public static ProtectionSystem valueOf(UUID uuid) {
        for (ProtectionSystem system : ProtectionSystem.values()) {
            if (!system.getUUID().equals(uuid)) continue;
            return system;
        }
        return null;
    }

    static {
        supported = EnumSet.noneOf(ProtectionSystem.class);
    }
}

