/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import androidx.annotation.NonNull;
import java.util.Locale;
import java.util.Objects;

public final class Quality {
    private final String name;
    private final String codecs;
    private final int bitrate;
    private final int width;
    private final int height;
    private final float framerate;

    Quality(@NonNull String name, @NonNull String codecs, int bitrate, int width, int height, float framerate) {
        this.name = name;
        this.codecs = codecs;
        this.bitrate = bitrate;
        this.width = width;
        this.height = height;
        this.framerate = framerate;
    }

    public String toString() {
        return String.format(Locale.ROOT, "name: %s, codecs %s, bitrate %d, resolution %d x %d framerate %.2f", this.name, this.codecs, this.bitrate, this.width, this.height, Float.valueOf(this.framerate));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quality)) {
            return false;
        }
        Quality quality = (Quality)o;
        return this.bitrate == quality.bitrate && this.width == quality.width && this.height == quality.height && Float.compare(quality.framerate, this.framerate) == 0 && Objects.equals(this.name, quality.name) && Objects.equals(this.codecs, quality.codecs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.codecs, this.bitrate, this.width, this.height, Float.valueOf(this.framerate));
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getCodecs() {
        return this.codecs;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getFramerate() {
        return this.framerate;
    }
}

