/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.amazonaws.ivs.player.Size;

public enum ResizeMode {
    FIT{

        @Override
        protected Size scaleTo(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
            float ratio = (float)dstHeight / (float)dstWidth;
            if ((float)srcHeight > (float)srcWidth * ratio) {
                return new Size(srcWidth, (int)((float)srcWidth * ratio));
            }
            return new Size((int)((float)srcHeight / ratio), srcHeight);
        }
    }
    ,
    FILL{

        @Override
        protected Size scaleTo(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
            float ratio = (float)dstHeight / (float)dstWidth;
            if ((float)srcHeight < (float)srcWidth * ratio) {
                return new Size(srcWidth, (int)((float)srcWidth * ratio));
            }
            return new Size((int)((float)srcHeight / ratio), srcHeight);
        }
    }
    ,
    ZOOM{

        @Override
        protected Size scaleTo(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
            return new Size(srcWidth, srcHeight);
        }
    };


    void setLayoutParams(SurfaceView surfaceView, int width, int height) {
        if (surfaceView != null && width > 0 && height > 0) {
            View parent = (View)surfaceView.getParent();
            if (parent == null) {
                parent = surfaceView;
            }
            if (parent.getWidth() > 0 && parent.getHeight() > 0) {
                Size scaled = this.scaleTo(parent.getWidth(), parent.getHeight(), width, height);
                ViewGroup.LayoutParams layoutParams = surfaceView.getLayoutParams();
                layoutParams.width = scaled.width;
                layoutParams.height = scaled.height;
                surfaceView.setLayoutParams(layoutParams);
            }
        }
    }

    protected abstract Size scaleTo(int var1, int var2, int var3, int var4);
}

