/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import com.amazonaws.ivs.player.Consumer;
import com.amazonaws.ivs.player.Function;
import java.util.NoSuchElementException;
import java.util.Objects;

abstract class Result<Err, R> {
    static <Err, R> Result<Err, R> error(Err error) {
        Objects.requireNonNull(error);
        return new Error(error);
    }

    static <Err, R> Result<Err, R> value(R value) {
        Objects.requireNonNull(value);
        return new Value(value);
    }

    Err getError() {
        throw new NoSuchElementException();
    }

    R getValue() {
        throw new NoSuchElementException();
    }

    abstract boolean isError();

    abstract boolean isOk();

    Result() {
    }

    R getOr(R otherValue) {
        return (R)this.fold(err -> otherValue, value -> this.getValue());
    }

    abstract void run(Consumer<Err> var1, Consumer<R> var2);

    abstract <U> Result<Err, U> flatMap(Function<R, Result<Err, U>> var1);

    abstract <U> U fold(Function<Err, U> var1, Function<R, U> var2);

    abstract <U> Result<Err, U> map(Function<R, U> var1);

    abstract Result<Err, R> ifError(Consumer<Err> var1);

    abstract Result<Err, R> ifOk(Consumer<R> var1);

    static class Error<Err, R>
    extends Result<Err, R> {
        private final Err error;

        Error(Err error) {
            Objects.requireNonNull(error);
            this.error = error;
        }

        @Override
        boolean isError() {
            return true;
        }

        @Override
        boolean isOk() {
            return false;
        }

        @Override
        Err getError() {
            return this.error;
        }

        @Override
        void run(Consumer<Err> errorConsumer, Consumer<R> valueConsumer) {
            errorConsumer.accept(this.error);
        }

        @Override
        <U> Result<Err, U> flatMap(Function<R, Result<Err, U>> mapper) {
            return Result.error(this.error);
        }

        @Override
        <U> U fold(Function<Err, U> errorFunction, Function<R, U> valueFunction) {
            return errorFunction.apply(this.error);
        }

        @Override
        Result<Err, R> ifError(Consumer<Err> errorConsumer) {
            errorConsumer.accept(this.error);
            return this;
        }

        @Override
        Result<Err, R> ifOk(Consumer<R> resultConsumer) {
            return this;
        }

        @Override
        <U> Result<Err, U> map(Function<R, U> mapper) {
            return Result.error(this.error);
        }
    }

    static final class Value<Err, R>
    extends Result<Err, R> {
        private final R value;

        Value(R value) {
            Objects.requireNonNull(value);
            this.value = value;
        }

        @Override
        boolean isError() {
            return false;
        }

        @Override
        boolean isOk() {
            return true;
        }

        @Override
        R getValue() {
            return this.value;
        }

        @Override
        void run(Consumer<Err> errorConsumer, Consumer<R> valueConsumer) {
            valueConsumer.accept(this.value);
        }

        @Override
        <U> Result<Err, U> flatMap(Function<R, Result<Err, U>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        <U> U fold(Function<Err, U> errorFunction, Function<R, U> valueFunction) {
            return valueFunction.apply(this.value);
        }

        @Override
        Result<Err, R> ifError(Consumer<Err> errorConsumer) {
            return this;
        }

        @Override
        Result<Err, R> ifOk(Consumer<R> valueConsumer) {
            valueConsumer.accept(this.value);
            return this;
        }

        @Override
        <U> Result<Err, U> map(Function<R, U> mapper) {
            return Result.value(mapper.apply(this.value));
        }
    }
}

