/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import androidx.annotation.NonNull;
import com.amazonaws.ivs.player.Logging;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionConfig {
    private final JSONObject data = new JSONObject();

    public SessionConfig() {
        try {
            this.data.put("adaptiveBitrate", (Object)new JSONObject());
            this.data.put("analytics", (Object)new JSONObject().put("additionalEventProperties", (Object)new JSONObject()));
        }
        catch (JSONException e) {
            Logging.w("Could not construct session data", e);
        }
    }

    public <T> SessionConfig addAnalyticsProperty(@NonNull String name, @NonNull T value) {
        try {
            this.data.getJSONObject("analytics").getJSONObject("additionalEventProperties").put(name, value);
        }
        catch (JSONException e) {
            Logging.w("Could not add an additional analytics property", e);
        }
        return this;
    }

    public SessionConfig addAnalyticsProperty(@NonNull String name, @NonNull Integer value) {
        try {
            this.data.getJSONObject("analytics").getJSONObject("additionalEventProperties").put(name, (Object)value);
        }
        catch (JSONException e) {
            Logging.w("Could not add an additional analytics property", e);
        }
        return this;
    }

    public SessionConfig setAdaptiveBitrateSurfaceSizeFilterEnabled(boolean enabled) {
        try {
            this.data.getJSONObject("adaptiveBitrate").put("surfaceSizeFilterEnabled", enabled);
        }
        catch (JSONException e) {
            Logging.w("Failed to update configuration ", e);
        }
        return this;
    }

    JSONObject get() {
        return this.data;
    }
}

