/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.net.Uri;
import androidx.annotation.NonNull;
import com.amazonaws.ivs.player.ErrorType;
import com.amazonaws.ivs.player.Quality;
import com.amazonaws.ivs.player.Releasable;
import com.amazonaws.ivs.player.SourceGroup;
import java.util.Set;

public interface Source
extends Releasable {
    public String getId();

    public Uri getUri();

    @Override
    public void release();

    public String getSessionData(@NonNull String var1);

    @NonNull
    public Set<Quality> getQualities();

    @NonNull
    public Set<SourceGroup> getGroups();

    @NonNull
    public long getTimeToLive();

    public static interface Listener {
        public void onLoad(@NonNull Source var1);

        public void onError(@NonNull LoadError var1);
    }

    public static class LoadError {
        private final ErrorType type;
        private final int code;
        private final String id;
        private final String message;
        private final Uri uri;

        LoadError(String id, String uri, ErrorType type, int code, String message) {
            this.id = id;
            this.uri = Uri.parse((String)uri);
            this.code = code;
            this.type = type;
            this.message = message;
        }

        public String getId() {
            return this.id;
        }

        public Uri getUri() {
            return this.uri;
        }

        @NonNull
        public ErrorType getErrorType() {
            return this.type;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

