/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.content.Context;
import com.amazonaws.ivs.player.EGLException;
import com.amazonaws.ivs.player.EGLManager;
import com.amazonaws.ivs.player.Experimental;
import com.amazonaws.ivs.player.Experiments;
import com.amazonaws.ivs.player.GLError;
import com.amazonaws.ivs.player.GLException;
import com.amazonaws.ivs.player.GPUAnalyticsEvent;
import com.amazonaws.ivs.player.HardwareInfo;
import com.amazonaws.ivs.player.IVSFeature;
import com.amazonaws.ivs.player.Platform;
import com.amazonaws.ivs.player.Releasable;
import com.amazonaws.ivs.player.Result;
import com.amazonaws.ivs.player.VideoFrameTransformer;
import com.amazonaws.ivs.player.json.Json;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class SuperResolution
extends IVSFeature<Config>
implements Releasable,
Experimental {
    private Platform platform = null;
    private EGLManager eglManager = null;
    private HardwareInfo hardwareInfo = null;
    private VideoFrameTransformer upscaleRefiner = null;
    TransformerExperimentState videoTransformerExperimentState = TransformerExperimentState.OFF;

    SuperResolution() {
        super("super_resolution", new Config());
        this.nativeHandle = this.Init();
    }

    boolean init(Context context, Platform platform) {
        this.platform = platform;
        if (this.videoTransformerExperimentState.compareTo(TransformerExperimentState.INITIALIZE) >= 0) {
            Result<EGLException, EGLManager> eglCreation = EGLManager.create();
            if (eglCreation.isError()) {
                this.reportError(eglCreation.getError());
                return false;
            }
            this.eglManager = eglCreation.getValue();
            Result<EGLException, HardwareInfo> hardwareInfoCreation = HardwareInfo.create(context, this.eglManager);
            if (hardwareInfoCreation.isError()) {
                this.reportError(hardwareInfoCreation.getError());
                return false;
            }
            this.hardwareInfo = hardwareInfoCreation.getValue();
            this.upscaleRefiner = new VideoFrameTransformer(this::reportError, this::reportAnalyticsEvent);
            if (!this.upscaleRefiner.init(this.eglManager, this.hardwareInfo)) {
                return false;
            }
        } else {
            return false;
        }
        return this.isEnabled;
    }

    VideoFrameTransformer getTransformer() {
        if (this.videoTransformerExperimentState.equals((Object)TransformerExperimentState.RUN)) {
            return this.upscaleRefiner;
        }
        return null;
    }

    @Override
    public void overrideWith(Experiments experiments) throws JSONException {
        VideoFrameTransformer transformer;
        String videoFrameTransformerGroup;
        String superResolutionGroup = experiments.getAssignedGroup(this.getDescription());
        if ("treatment".equals(superResolutionGroup)) {
            this.isEnabled = true;
        }
        if ((videoFrameTransformerGroup = experiments.getAssignedGroup((transformer = new VideoFrameTransformer(this::reportError, this::reportAnalyticsEvent)).getDescription())).equals("AB-1")) {
            this.videoTransformerExperimentState = TransformerExperimentState.INITIALIZE;
        } else if (videoFrameTransformerGroup.equals("AB-2")) {
            this.videoTransformerExperimentState = TransformerExperimentState.RUN;
        }
    }

    @Override
    public void overrideWith(JSONObject payload) throws JSONException {
        if (!this.isEnabled) {
            return;
        }
        if (payload != null) {
            this.config.updateWithJson(payload);
            this.isEnabled = ((Config)this.config.asImpl()).enabled;
        }
    }

    @Override
    JSONObject getCriteriaForFeature() throws JSONException {
        Map<String, String> deviceProperties = this.platform.getDeviceProperties();
        JSONObject criteria = new JSONObject();
        criteria.put("deviceManufacturer", (Object)deviceProperties.get("device_manufacturer"));
        criteria.put("deviceModel", (Object)deviceProperties.get("device_model"));
        criteria.put("deviceOsVersion", (Object)deviceProperties.get("device_os_version"));
        return criteria;
    }

    @Override
    public void release() {
        if (this.upscaleRefiner != null) {
            this.upscaleRefiner.release();
        }
        if (this.hardwareInfo != null) {
            this.hardwareInfo.release();
        }
        if (this.eglManager != null) {
            this.eglManager.release();
        }
        this.Release(this.nativeHandle);
        this.nativeHandle = 0L;
    }

    @Override
    public Experiments.Experiment getDescription() {
        return Experiments.Experiment.SUPER_RESOLUTION;
    }

    @Override
    protected void reportError(RuntimeException exception) {
        if (exception instanceof GLException) {
            GLException glException = (GLException)exception;
            for (GLError error : glException.errors) {
                super.reportAnalyticsEvent(GPUAnalyticsEvent.createErrorEvent(this.hardwareInfo, error));
            }
        } else if (exception instanceof EGLException) {
            EGLException eglException = (EGLException)exception;
            super.reportAnalyticsEvent(GPUAnalyticsEvent.createErrorEvent(this.hardwareInfo, eglException));
        } else {
            super.reportError(exception);
        }
    }

    private native long Init();

    private native void Release(long var1);

    private native String getSuperResPayload(long var1, String var3);

    public static class Config
    extends IVSFeature.IVSConfig<Config> {
        @Json(required=true)
        public boolean enabled = false;
    }

    static enum TransformerExperimentState {
        OFF(0),
        INITIALIZE(1),
        RUN(2);

        private int value;

        private TransformerExperimentState(int i) {
            this.value = i;
        }
    }
}

