/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.os.Trace;
import android.view.Choreographer;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import com.amazonaws.ivs.player.Clock;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.MediaRenderer;
import com.amazonaws.ivs.player.Size;
import com.amazonaws.ivs.player.VideoRenderer;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

class SurfaceRenderer
implements MediaRenderer,
VideoRenderer,
Choreographer.FrameCallback {
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private Surface surface;
    private final Object surfaceLock;
    private WeakReference<VideoRenderer.VideoSizeListener> sizeListener;
    private Size size;
    private long frameTimeNanos;
    private long lastMediaTime = -1L;
    private long mediaTime;
    private long renderPresentationTime = -1L;
    private long startTime;
    private long syncInterval;
    private int droppedFrames;
    private int renderedFrames;
    private int lastFps;
    private int lastRenderedFrames;
    private boolean hasFutureFrame;
    private boolean invalidateMediaTime;
    private boolean mediaTimeChanged;
    private boolean sizeChanged;
    private boolean surfaceChanged;
    private float playbackRate = 1.0f;
    private Handler handler;
    private Choreographer choreographer;
    private VideoRenderer.SurfaceChangeListener surfaceChangeListener;

    SurfaceRenderer(Context context, VideoRenderer.VideoSizeListener listener) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.surfaceLock = new Object();
        this.size = new Size(0, 0);
        this.sizeListener = new WeakReference<VideoRenderer.VideoSizeListener>(listener);
        this.syncInterval = TimeUnit.MILLISECONDS.toMicros(33L);
        this.hasFutureFrame = false;
        this.invalidateMediaTime = true;
        WindowManager window = (WindowManager)context.getSystemService("window");
        if (window != null) {
            Display display = window.getDefaultDisplay();
            float refreshRate = display.getRefreshRate();
            this.syncInterval = (long)(1.0f / refreshRate * (float)TimeUnit.SECONDS.toMicros(1L));
        }
        this.handler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Surface getSurface() {
        Object object = this.surfaceLock;
        synchronized (object) {
            return this.surface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSurface(Surface surface) {
        Object object = this.surfaceLock;
        synchronized (object) {
            if (this.surface != surface) {
                this.surface = surface;
                if (this.surfaceChangeListener != null) {
                    this.surfaceChangeListener.onSurfaceChange(surface);
                }
                this.surfaceChanged = true;
                this.sizeChanged = true;
            }
        }
    }

    @Override
    public void setSurfaceChangeListener(VideoRenderer.SurfaceChangeListener listener) {
        this.surfaceChangeListener = listener;
    }

    @Override
    public void configure(MediaFormat format) {
        Trace.beginSection((String)"SurfaceRenderer configure");
        int width = format.getInteger("width");
        int height = format.getInteger("height");
        if (format.containsKey(FORMAT_KEY_CROP_LEFT) && format.containsKey(FORMAT_KEY_CROP_RIGHT) && format.containsKey(FORMAT_KEY_CROP_TOP) && format.containsKey(FORMAT_KEY_CROP_BOTTOM)) {
            int cropLeft = format.getInteger(FORMAT_KEY_CROP_LEFT);
            int cropRight = format.getInteger(FORMAT_KEY_CROP_RIGHT);
            int cropTop = format.getInteger(FORMAT_KEY_CROP_TOP);
            int cropBottom = format.getInteger(FORMAT_KEY_CROP_BOTTOM);
            width = cropRight - cropLeft + 1;
            height = cropBottom - cropTop + 1;
        }
        Size current = new Size(width, height);
        if (this.size == null || !this.size.equals(current)) {
            boolean initialChange = this.size == null;
            this.size = current;
            this.sizeChanged = true;
            if (initialChange) {
                this.updateVideoSize();
            }
        }
        Trace.endSection();
    }

    @Override
    public void flush() {
        Trace.beginSection((String)"SurfaceRenderer flush");
        this.droppedFrames = 0;
        this.renderedFrames = 0;
        this.lastFps = 0;
        this.lastRenderedFrames = 0;
        this.renderPresentationTime = -1L;
        this.lastMediaTime = -1L;
        this.mediaTime = 0L;
        this.startTime = 0L;
        this.invalidateMediaTime = true;
        this.hasFutureFrame = false;
        Trace.endSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(MediaCodec codec, int index, long presentationTimeUs) {
        Trace.beginSection((String)("SurfaceRenderer render " + presentationTimeUs));
        if (this.mediaTime == 0L) {
            this.mediaTime = presentationTimeUs;
            this.startTime = System.nanoTime();
        }
        long now = System.nanoTime();
        long currentTime = this.getCurrentMediaTimeUs();
        long releaseTime = (long)((float)(currentTime > 0L ? presentationTimeUs - currentTime : 0L) / this.playbackRate);
        boolean render = true;
        long renderSystemTime = 0L;
        renderSystemTime = now + TimeUnit.MICROSECONDS.toNanos(releaseTime);
        if (releaseTime <= 0L || releaseTime > 3L * this.syncInterval) {
            if (releaseTime >= -this.syncInterval && this.startTime > 0L) {
                long maxRelease;
                this.hasFutureFrame = true;
                long minRelease = TimeUnit.MILLISECONDS.toMicros(10L);
                long sleep = releaseTime - minRelease - 2L * this.syncInterval;
                if (sleep > (maxRelease = TimeUnit.SECONDS.toMicros(1L))) {
                    Logging.w("SurfaceRender waiting " + sleep + " us media " + currentTime + " presentation " + presentationTimeUs);
                }
                if (sleep >= minRelease) {
                    Clock.sleep(TimeUnit.MICROSECONDS.toMillis(Math.min(sleep, maxRelease)));
                }
            } else {
                this.hasFutureFrame = false;
                render = false;
            }
        } else {
            this.hasFutureFrame = false;
        }
        Object object = this.surfaceLock;
        synchronized (object) {
            if (this.surface == null) {
                render = false;
            }
            if (render) {
                long syncIntervalNanos = TimeUnit.MICROSECONDS.toNanos(this.syncInterval);
                long frames = (renderSystemTime - this.frameTimeNanos) / syncIntervalNanos;
                renderSystemTime = this.frameTimeNanos + syncIntervalNanos * frames;
                codec.releaseOutputBuffer(index, renderSystemTime);
            } else {
                codec.releaseOutputBuffer(index, render);
            }
        }
        if (render) {
            ++this.renderedFrames;
            this.updateVideoSize();
            if (this.surfaceChanged) {
                this.surfaceChanged = false;
            }
            if (this.mediaTimeChanged) {
                this.mediaTimeChanged = false;
            }
        } else if (!this.surfaceChanged && !this.mediaTimeChanged) {
            ++this.droppedFrames;
        }
        this.renderPresentationTime = presentationTimeUs;
        Trace.endSection();
    }

    @Override
    public void render(ByteBuffer buffer, int size, long presentationTimeUs) {
        this.renderPresentationTime = presentationTimeUs;
        ++this.renderedFrames;
    }

    @Override
    public void start() {
        Trace.beginSection((String)"SurfaceRenderer start");
        this.startTime = System.nanoTime();
        this.addFrameCallback();
        this.invalidateMediaTime = true;
        Trace.endSection();
    }

    @Override
    public void stop() {
        Trace.beginSection((String)"SurfaceRenderer stop");
        this.startTime = 0L;
        this.mediaTime = 0L;
        this.removeFrameCallback();
        Trace.endSection();
    }

    @Override
    public void release() {
        Trace.beginSection((String)"SurfaceRenderer release");
        this.removeFrameCallback();
        Trace.endSection();
    }

    @Override
    public long getRenderedPresentationTime() {
        return Math.min(this.getCurrentMediaTimeUs(), this.renderPresentationTime);
    }

    @Override
    public boolean shouldProcessMore() {
        return !this.hasFutureFrame;
    }

    @Override
    public void setMediaTime(long time) {
        if (time <= 0L) {
            this.mediaTime = 0L;
            Logging.d("SurfaceRenderer reset time");
        } else if (this.invalidateMediaTime) {
            this.mediaTime = time;
            this.startTime = System.nanoTime();
            this.invalidateMediaTime = false;
            this.mediaTimeChanged = true;
            Logging.d("SurfaceRenderer set media time " + this.mediaTime);
        } else {
            long currentMediaTimeUs = this.getCurrentMediaTimeUs();
            long delta = Math.min(Math.abs(currentMediaTimeUs - time), this.syncInterval);
            if (delta > 1000L) {
                if (currentMediaTimeUs > time) {
                    if (this.mediaTime <= delta) {
                        this.mediaTime = currentMediaTimeUs;
                        this.startTime = System.nanoTime();
                    }
                    this.mediaTime -= delta;
                } else {
                    this.mediaTime += delta;
                }
            }
        }
        this.lastMediaTime = time;
    }

    @Override
    public void setPlaybackRate(float rate) {
        if (this.playbackRate != rate) {
            this.playbackRate = rate;
            this.mediaTime = 0L;
            this.startTime = 0L;
        }
    }

    @Override
    public int getDroppedFrames() {
        return this.droppedFrames;
    }

    @Override
    public int getRenderedFrames() {
        return this.renderedFrames;
    }

    @Override
    public int getFrameRate() {
        return this.lastFps;
    }

    @Override
    public Size getVideoSize() {
        return this.size;
    }

    private void updateVideoSize() {
        if (this.sizeChanged) {
            this.sizeChanged = false;
            VideoRenderer.VideoSizeListener listener = (VideoRenderer.VideoSizeListener)this.sizeListener.get();
            if (listener != null) {
                listener.onSizeChange(this.size.width, this.size.height);
            }
        }
    }

    private long getCurrentMediaTimeUs() {
        if (this.mediaTime <= 0L) {
            return -1L;
        }
        long elapsed = (long)((float)(System.nanoTime() - this.startTime) * this.playbackRate);
        return this.mediaTime + TimeUnit.NANOSECONDS.toMicros(elapsed);
    }

    private Choreographer getChoreographer() {
        if (this.choreographer == null) {
            this.choreographer = Choreographer.getInstance();
        }
        return this.choreographer;
    }

    private void addFrameCallback() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                SurfaceRenderer.this.getChoreographer().postFrameCallback((Choreographer.FrameCallback)SurfaceRenderer.this);
            }
        });
    }

    private void removeFrameCallback() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                SurfaceRenderer.this.getChoreographer().removeFrameCallback((Choreographer.FrameCallback)SurfaceRenderer.this);
            }
        });
    }

    public void doFrame(long frameTimeNanos) {
        this.frameTimeNanos = frameTimeNanos;
        this.lastFps = this.renderedFrames - this.lastRenderedFrames;
        this.lastRenderedFrames = this.renderedFrames;
        this.getChoreographer().postFrameCallbackDelayed((Choreographer.FrameCallback)this, 1000L);
    }
}

