/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import androidx.annotation.NonNull;
import com.amazonaws.ivs.player.Cue;
import java.util.Objects;

public class TextCue
extends Cue {
    public final float line;
    public final float size;
    public final float position;
    @NonNull
    public final TextAlignment textAlign;
    @NonNull
    public final String text;

    TextCue(long startTime, long endTime, float line, float size, float position, int textAlign, @NonNull String text) {
        super(startTime, endTime);
        this.line = line;
        this.size = size;
        this.position = position;
        this.textAlign = TextAlignment.fromInt(textAlign);
        this.text = text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextCue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextCue textCue = (TextCue)o;
        return Float.compare(textCue.line, this.line) == 0 && Float.compare(textCue.size, this.size) == 0 && Float.compare(textCue.position, this.position) == 0 && this.textAlign == textCue.textAlign && Objects.equals(this.text, textCue.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.startTime, this.endTime, Float.valueOf(this.line), Float.valueOf(this.size), Float.valueOf(this.position), this.textAlign, this.text});
    }

    public String toString() {
        return "TextCue{startTime=" + this.startTime + ", endTime=" + this.endTime + ", line=" + this.line + ", size=" + this.size + ", position=" + this.position + ", textAlign=" + (Object)((Object)this.textAlign) + ", text='" + this.text + '\'' + '}';
    }

    public static enum TextAlignment {
        START,
        MIDDLE,
        END;


        static TextAlignment fromInt(int code) {
            if (code < 0 || code >= TextAlignment.values().length) {
                return START;
            }
            return TextAlignment.values()[code];
        }
    }
}

