/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

public class UnavailableQuality {
    private final String name;
    private final String codecs;
    private final int width;
    private final int height;
    private final String group;
    private final int bitrate;
    private final float framerate;
    private final List<String> filterReasons;
    private final List<String> authReasons;

    public UnavailableQuality(@NonNull String name, @NonNull String codecs, int width, int height, @NonNull String group, int bitrate, float framerate, @NonNull List<String> filterReasons, @NonNull List<String> authReasons) {
        this.name = name;
        this.codecs = codecs;
        this.width = width;
        this.height = height;
        this.group = group;
        this.bitrate = bitrate;
        this.framerate = framerate;
        this.filterReasons = new ArrayList<String>(filterReasons);
        this.authReasons = new ArrayList<String>(authReasons);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getCodecs() {
        return this.codecs;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @NonNull
    public String getGroup() {
        return this.group;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public float getFramerate() {
        return this.framerate;
    }

    @NonNull
    public List<String> getFilterReasons() {
        return new ArrayList<String>(this.filterReasons);
    }

    @NonNull
    public List<String> getAuthReasons() {
        return new ArrayList<String>(this.authReasons);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnavailableQuality other = (UnavailableQuality)o;
        return this.name.equals(other.name) && this.group.equals(other.group) && this.width == other.width && this.height == other.height && this.codecs.equals(other.codecs) && this.bitrate == other.bitrate && this.framerate == other.framerate;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.codecs.hashCode();
        result = 31 * result + this.bitrate;
        result = 31 * result + Float.floatToIntBits(this.framerate);
        return result;
    }
}

