/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.text.TextUtils;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.MediaCodecFactory;
import com.amazonaws.ivs.player.Quality;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VideoCapabilities {
    int maxBitrate;
    int maxFramerate;
    int maxWidth;
    int maxHeight;
    int maxProfile;
    int maxLevel;
    int maxInstances;
    boolean isSoftware;
    public static final float MAX_PLAYBACK_RATE = 2.0f;
    public static final float DEFAULT_PLAYBACK_RATE = 1.0f;
    private static final float[] PLAYBACK_RATES = new float[]{2.0f, 1.5f, 1.0f};
    private static final Map<String, VideoCapabilities> CAPABILITIES = new HashMap<String, VideoCapabilities>();
    private static final Map<String, MediaCodecInfo> MEDIACODEC_CAPABILITIES = new HashMap<String, MediaCodecInfo>();
    private static final List<String> VP9_SOFTWARE_CODECS = Arrays.asList("OMX.google.vp9.decoder", "c2.android.vp9.decoder", "c2.google.vp9.decoder");
    private static final List<String> HEVC_SOFTWARE_CODECS = Arrays.asList("OMX.google.hevc.decoder", "c2.android.hevc.decoder", "c2.google.hevc.decoder");
    private static final List<String> AV1_SOFTWARE_CODECS = Arrays.asList("c2.android.av1.decoder");
    private static final Map<String, MediaFormat> MEDIA_FORMATS = new HashMap<String, MediaFormat>();

    private VideoCapabilities() {
    }

    public static boolean isTypeSupported(String mediaType) {
        if (mediaType.equalsIgnoreCase("video/avc")) {
            return true;
        }
        if (mediaType.equalsIgnoreCase("video/x-vnd.on2.vp9") && Build.VERSION.SDK_INT >= 23) {
            MediaCodecList list = new MediaCodecList(0);
            MediaFormat format = VideoCapabilities.getMediaFormat(mediaType);
            String decoder = list.findDecoderForFormat(format);
            return !VP9_SOFTWARE_CODECS.contains(decoder);
        }
        if (mediaType.equalsIgnoreCase("video/hevc")) {
            MediaCodecList list = new MediaCodecList(0);
            MediaFormat format = VideoCapabilities.getMediaFormat(mediaType);
            String decoder = list.findDecoderForFormat(format);
            return !HEVC_SOFTWARE_CODECS.contains(decoder);
        }
        if (mediaType.equalsIgnoreCase("video/av01")) {
            MediaCodecList list = new MediaCodecList(0);
            MediaFormat format = VideoCapabilities.getMediaFormat(mediaType);
            String decoder = list.findDecoderForFormat(format);
            return !AV1_SOFTWARE_CODECS.contains(decoder);
        }
        return false;
    }

    private static MediaFormat getMediaFormat(String mediaType) {
        MediaFormat fmt = MEDIA_FORMATS.get(mediaType);
        if (fmt == null) {
            fmt = MediaFormat.createVideoFormat((String)mediaType, (int)1920, (int)1080);
            MEDIA_FORMATS.put(mediaType, fmt);
        }
        return fmt;
    }

    public static float getMaxPlaybackRateForQuality(String mediaType, Quality quality) {
        if (quality == null || TextUtils.isEmpty((CharSequence)mediaType)) {
            Logging.e("getMaxPlaybackRateForQuality: invalid parameters");
            return 1.0f;
        }
        MediaCodecInfo codecInfo = VideoCapabilities.getMediaCodecInfo(mediaType);
        if (codecInfo != null && quality.getFramerate() > 1.0f) {
            MediaCodecInfo.CodecCapabilities codecCaps = codecInfo.getCapabilitiesForType(mediaType);
            MediaCodecInfo.VideoCapabilities videoCaps = codecCaps.getVideoCapabilities();
            for (float rate : PLAYBACK_RATES) {
                if (!videoCaps.areSizeAndRateSupported(quality.getWidth(), quality.getHeight(), (double)(quality.getFramerate() * rate))) continue;
                return rate;
            }
        } else if (Float.compare(quality.getFramerate(), 0.0f) == 0 && Float.compare(quality.getWidth(), 0.0f) == 0 && Float.compare(quality.getHeight(), 0.0f) == 0) {
            return 2.0f;
        }
        return 1.0f;
    }

    public static VideoCapabilities getCapabilities(String mediaType) {
        if (CAPABILITIES.containsKey(mediaType)) {
            return CAPABILITIES.get(mediaType);
        }
        VideoCapabilities capabilities = new VideoCapabilities();
        capabilities.maxBitrate = Integer.MAX_VALUE;
        capabilities.maxWidth = 1920;
        capabilities.maxHeight = 1280;
        capabilities.maxFramerate = 30;
        capabilities.maxProfile = 100;
        capabilities.maxLevel = 42;
        capabilities.maxInstances = 1;
        MediaCodecInfo codecInfo = VideoCapabilities.getMediaCodecInfo(mediaType);
        if (codecInfo != null) {
            capabilities.setVideoCapabilities(mediaType, codecInfo);
        }
        CAPABILITIES.put(mediaType, capabilities);
        return capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MediaCodecInfo getMediaCodecInfo(String mediaType) {
        MediaCodecInfo result = null;
        if (MEDIACODEC_CAPABILITIES.containsKey(mediaType)) {
            result = MEDIACODEC_CAPABILITIES.get(mediaType);
        } else {
            try {
                List<MediaCodecInfo> info = MediaCodecFactory.findSupportedCodecs(mediaType, false);
                if (!info.isEmpty()) {
                    result = info.get(0);
                }
            }
            catch (Exception e) {
                Logging.e("Failed to get codec capabilities", e);
            }
            MediaCodec codec = null;
            try {
                codec = MediaCodecFactory.createCodec(mediaType, false);
                if (codec != null) {
                    result = codec.getCodecInfo();
                }
            }
            catch (Exception e) {
                Logging.e("Failed to get codec capabilities", e);
            }
            finally {
                if (codec != null) {
                    codec.release();
                }
            }
            if (result != null) {
                MEDIACODEC_CAPABILITIES.put(mediaType, result);
            }
        }
        return result;
    }

    private void setVideoCapabilities(String mediaType, MediaCodecInfo info) {
        MediaCodecInfo.CodecCapabilities codecCaps = info.getCapabilitiesForType(mediaType);
        MediaCodecInfo.VideoCapabilities video = codecCaps.getVideoCapabilities();
        this.maxBitrate = (Integer)video.getBitrateRange().getUpper();
        this.maxWidth = (Integer)video.getSupportedWidths().getUpper();
        this.maxHeight = (Integer)video.getSupportedHeights().getUpper();
        this.maxFramerate = (Integer)video.getSupportedFrameRates().getUpper();
        if (Build.VERSION.SDK_INT >= 23) {
            this.maxInstances = codecCaps.getMaxSupportedInstances();
        }
        if (MediaCodecFactory.limitMaxDecodeSize(info.getName())) {
            this.maxWidth = 1920;
            this.maxHeight = 1088;
        }
        int maxProfile = 0;
        int maxLevel = 0;
        for (int i = 0; i < codecCaps.profileLevels.length; ++i) {
            int profile = codecCaps.profileLevels[i].profile;
            int level = codecCaps.profileLevels[i].level;
            if (profile > maxProfile) {
                if (mediaType.equals("video/avc")) {
                    if (profile <= 64) {
                        maxProfile = profile;
                    }
                } else {
                    maxProfile = profile;
                }
            }
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        if (mediaType.equals("video/avc")) {
            if (maxProfile == 0) {
                maxProfile = 8;
            }
            if (maxLevel == 0) {
                maxLevel = 8192;
            }
        } else if (mediaType.equals("video/x-vnd.on2.vp9")) {
            if (maxProfile == 0) {
                maxProfile = 1;
            }
            if (maxLevel == 0) {
                maxLevel = 128;
            }
        } else if (mediaType.equals("video/av01") && maxLevel == 0) {
            maxLevel = 2;
        }
        if (mediaType.equals("video/avc")) {
            this.maxProfile = VideoCapabilities.avcProfileIndicationFromOMX(maxProfile);
            this.maxLevel = VideoCapabilities.avcLevelIndicationFromOMX(maxLevel);
        } else if (mediaType.equals("video/x-vnd.on2.vp9")) {
            this.maxProfile = VideoCapabilities.vp9ProfileIndicationFromOMX(maxProfile);
            this.maxLevel = VideoCapabilities.vp9LevelIndicationFromOMX(maxLevel);
            this.isSoftware = VP9_SOFTWARE_CODECS.contains(info.getName());
        } else if (mediaType.equals("video/av01")) {
            this.maxProfile = VideoCapabilities.av1ProfileIndicationFromOMX(maxProfile);
            this.maxLevel = VideoCapabilities.av1LevelIndicationFromOMX(maxLevel);
        } else if (mediaType.equals("video/hevc")) {
            this.maxProfile = VideoCapabilities.hevcProfileIndicationFromOMX(maxProfile);
            this.maxLevel = VideoCapabilities.hevcLevelIndicationFromOMX(maxLevel);
            this.isSoftware = HEVC_SOFTWARE_CODECS.contains(info.getName());
        }
    }

    private static int avcProfileIndicationFromOMX(int profile) {
        switch (profile) {
            case 1: {
                return 66;
            }
            default: {
                return 77;
            }
            case 4: {
                return 88;
            }
            case 8: {
                return 100;
            }
            case 16: {
                return 110;
            }
            case 32: {
                return 122;
            }
            case 64: 
        }
        return 244;
    }

    private static int avcLevelIndicationFromOMX(int level) {
        switch (level) {
            case 2: {
                return 9;
            }
            case 1: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 8: {
                return 12;
            }
            case 16: {
                return 13;
            }
            case 32: {
                return 20;
            }
            case 64: {
                return 21;
            }
            case 128: {
                return 22;
            }
            case 256: {
                return 30;
            }
            case 512: {
                return 31;
            }
            case 1024: {
                return 32;
            }
            case 2048: {
                return 40;
            }
            case 4096: {
                return 41;
            }
            default: {
                return 42;
            }
            case 16384: {
                return 50;
            }
            case 32768: {
                return 51;
            }
            case 65536: {
                return 52;
            }
            case 131072: {
                return 60;
            }
            case 262144: {
                return 61;
            }
            case 524288: 
        }
        return 62;
    }

    private static int av1ProfileIndicationFromOMX(int profile) {
        switch (profile) {
            default: 
        }
        return 0;
    }

    private static int av1LevelIndicationFromOMX(int level) {
        switch (level) {
            default: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
            case 256: {
                return 8;
            }
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 13;
            }
            case 16384: {
                return 14;
            }
            case 32768: {
                return 15;
            }
            case 65536: {
                return 16;
            }
            case 131072: {
                return 17;
            }
            case 262144: {
                return 18;
            }
            case 524288: {
                return 19;
            }
            case 0x100000: {
                return 20;
            }
            case 0x200000: {
                return 21;
            }
            case 0x400000: {
                return 22;
            }
            case 0x800000: 
        }
        return 23;
    }

    private static int vp9ProfileIndicationFromOMX(int profile) {
        switch (profile) {
            default: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: 
            case 4096: {
                return 2;
            }
            case 8: 
            case 8192: 
        }
        return 3;
    }

    private static int vp9LevelIndicationFromOMX(int level) {
        switch (level) {
            case 1: {
                return 10;
            }
            case 4: {
                return 20;
            }
            case 16: {
                return 30;
            }
            case 64: {
                return 40;
            }
            case 256: {
                return 50;
            }
            case 2048: {
                return 60;
            }
            case 2: {
                return 11;
            }
            case 8: {
                return 21;
            }
            case 32: {
                return 31;
            }
            case 128: {
                return 41;
            }
            default: {
                return 51;
            }
            case 4096: {
                return 61;
            }
            case 8192: 
        }
        return 62;
    }

    private static int hevcProfileIndicationFromOMX(int profile) {
        switch (profile) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 4096: 
            case 8192: {
                return 2;
            }
            case 4: 
        }
        return 3;
    }

    private static int hevcLevelIndicationFromOMX(int level) {
        switch (level) {
            default: {
                return 30;
            }
            case 4: 
            case 8: {
                return 60;
            }
            case 16: 
            case 32: {
                return 63;
            }
            case 64: 
            case 128: {
                return 90;
            }
            case 256: 
            case 512: {
                return 93;
            }
            case 1024: 
            case 2048: {
                return 120;
            }
            case 4096: 
            case 8192: {
                return 123;
            }
            case 16384: 
            case 32768: {
                return 150;
            }
            case 65536: 
            case 131072: {
                return 153;
            }
            case 262144: 
            case 524288: {
                return 156;
            }
            case 0x100000: 
            case 0x200000: {
                return 180;
            }
            case 0x400000: 
            case 0x800000: {
                return 183;
            }
            case 0x1000000: 
            case 0x2000000: 
        }
        return 186;
    }

    public int getMaxBitrate() {
        return this.maxBitrate;
    }

    public int getMaxFramerate() {
        return this.maxFramerate;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxProfile() {
        return this.maxProfile;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public String toString() {
        return "maxBitrate=" + this.maxBitrate + ", maxFramerate=" + this.maxFramerate + ", maxWidth=" + this.maxWidth + ", maxHeight=" + this.maxHeight + ", maxProfile=" + this.maxProfile + ", maxLevel=" + this.maxLevel;
    }
}

