/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.graphics.SurfaceTexture;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazonaws.ivs.player.Consumer;
import com.amazonaws.ivs.player.DecodedImageBuffer;
import com.amazonaws.ivs.player.EGLException;
import com.amazonaws.ivs.player.EGLManager;
import com.amazonaws.ivs.player.Experimental;
import com.amazonaws.ivs.player.Experiments;
import com.amazonaws.ivs.player.GLException;
import com.amazonaws.ivs.player.GLManager;
import com.amazonaws.ivs.player.GPUAnalyticsEvent;
import com.amazonaws.ivs.player.HardwareInfo;
import com.amazonaws.ivs.player.Performance;
import com.amazonaws.ivs.player.Releasable;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class VideoFrameTransformer
implements SurfaceTexture.OnFrameAvailableListener,
Releasable,
Experimental {
    private Surface inputSurface = null;
    private EGLManager.IVSSurface outputRenderSurface = null;
    private EGLSurface offscreenSurface = null;
    private SurfaceTexture surfaceTexture;
    private GLManager.Shader textureExternalShader;
    private Handler renderHandler;
    private ExecutorService renderExecutor;
    private GLManager.Texture textureExternal;
    private EGLManager eglManager;
    private Future<DecodedImageBuffer> sampleInFlight = null;
    private final LinkedList<DecodedImageBuffer> samplesToBeRendered = new LinkedList();
    private HardwareInfo info;
    private final Performance.Monitor performanceMonitor;
    private final Consumer<RuntimeException> errorCallback;
    private final Consumer<Object> analyticsCallback;
    private long FrameIndex = 0L;
    private final AtomicBoolean paused = new AtomicBoolean();
    private final AtomicBoolean wantsFrame = new AtomicBoolean();
    private long presentationTimestampPlug = -1L;

    @Override
    public Experiments.Experiment getDescription() {
        return Experiments.Experiment.ANDROID_GPU;
    }

    VideoFrameTransformer(Consumer<RuntimeException> errorCallback, Consumer<Object> analyticsCallback) {
        this.errorCallback = errorCallback;
        this.analyticsCallback = analyticsCallback;
        this.performanceMonitor = new Performance.Monitor();
        this.paused.set(true);
        this.wantsFrame.set(false);
    }

    boolean init(@NonNull EGLManager eglManager, @NonNull HardwareInfo info) {
        boolean isSetup;
        try (Performance.Trackable ignored = this.performanceMonitor.time("init");){
            HandlerThread renderThreadOrchestrator = new HandlerThread("RenderOrchestrator", -4);
            renderThreadOrchestrator.start();
            this.renderHandler = new Handler(renderThreadOrchestrator.getLooper());
            this.eglManager = eglManager;
            this.info = info;
            this.renderExecutor = Executors.newSingleThreadExecutor(runnable -> {
                Thread t = new Thread(runnable);
                t.setName("RenderExecutor");
                t.setPriority(10);
                return t;
            });
            isSetup = eglManager.createEGLOffscreenSurface().fold(eglException -> {
                this.errorCallback.accept((RuntimeException)eglException);
                return false;
            }, eglSurface -> {
                this.offscreenSurface = eglSurface;
                return eglManager.currentCall(() -> GLManager.createShader(36197), this.offscreenSurface).fold(glException -> {
                    this.errorCallback.accept((RuntimeException)glException);
                    return false;
                }, shader -> {
                    this.textureExternalShader = shader;
                    return true;
                });
            });
        }
        if (isSetup) {
            this.inputSurface = this.createInputSurface();
            this.analyticsCallback.accept(GPUAnalyticsEvent.createInitEvent(info, this.performanceMonitor.getSnapshot("init")));
        }
        return isSetup;
    }

    public Surface getInputSurface() {
        return this.inputSurface;
    }

    private Surface createInputSurface() {
        try (Performance.Trackable ignored = this.performanceMonitor.time("createInputSurface");){
            Surface surface = this.eglManager.currentCall(() -> GLManager.createTexture(36197), this.offscreenSurface).fold(glException -> {
                this.errorCallback.accept((RuntimeException)glException);
                return null;
            }, texture -> {
                this.textureExternal = texture;
                this.surfaceTexture = new SurfaceTexture(texture.id);
                this.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this, this.renderHandler);
                return new Surface(this.surfaceTexture);
            });
            return surface;
        }
    }

    boolean setOutputSurface(Surface outputSurface) {
        if (this.outputRenderSurface != null) {
            this.outputRenderSurface.release();
            this.outputRenderSurface = null;
        }
        if (outputSurface == null) {
            return true;
        }
        return this.eglManager.createIVSSurface(outputSurface).fold(eglException -> {
            this.errorCallback.accept((RuntimeException)eglException);
            return false;
        }, ivsSurface -> {
            this.outputRenderSurface = ivsSurface;
            return true;
        });
    }

    void submitVideoSample(DecodedImageBuffer sample) {
        this.renderHandler.post(() -> this.renderNextSample(sample));
    }

    void onFrameRendered(int textureId, int targetType, long presentationTimeStamp) {
        if (this.paused.get()) {
            return;
        }
        this.wantsFrame.set(true);
        this.eglManager.currentCall(() -> {
            try (Performance.Trackable ignored = this.performanceMonitor.time("render");){
                int width = this.outputRenderSurface.width();
                int height = this.outputRenderSurface.height();
                GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
                GLException drawException = this.textureExternalShader.draw(this.textureExternal);
                if (drawException != null) {
                    Log.e((String)"VideoFrameTransformer", (String)("Exception " + drawException));
                    this.errorCallback.accept(drawException);
                }
                if (this.outputRenderSurface != null) {
                    this.outputRenderSurface.setPresentationTimestamp(presentationTimeStamp * 1000L);
                    boolean swapResult = true;
                    if (!this.paused.get()) {
                        swapResult = this.outputRenderSurface.swapBuffers();
                    }
                    if (!swapResult) {
                        this.errorCallback.accept(new EGLException("EGLSwapBuffers fail", 0));
                    }
                }
            }
        }, this.outputRenderSurface.eglSurface);
        ++this.FrameIndex;
        if (this.FrameIndex >= 1800L) {
            this.analyticsCallback.accept(GPUAnalyticsEvent.createStatusEvent(this.info, this.performanceMonitor.getSnapshot("capture"), this.performanceMonitor.getSnapshot("transform"), this.performanceMonitor.getSnapshot("render")));
            this.FrameIndex = 0L;
            this.performanceMonitor.reset("capture");
            this.performanceMonitor.reset("transform");
            this.performanceMonitor.reset("render");
        }
        this.renderNextSample(null);
    }

    synchronized void pause() {
        this.paused.set(true);
    }

    synchronized void play() {
        if (this.paused.compareAndSet(true, false)) {
            this.wantsFrame.set(true);
        }
    }

    synchronized long bufferDurationUs() {
        if (this.samplesToBeRendered.isEmpty()) {
            return 0L;
        }
        return this.samplesToBeRendered.getLast().presentationTimeUs - this.samplesToBeRendered.getFirst().presentationTimeUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        VideoFrameTransformer videoFrameTransformer = this;
        synchronized (videoFrameTransformer) {
            if (this.sampleInFlight != null && !this.sampleInFlight.isCancelled() && !this.sampleInFlight.isDone()) {
                try {
                    this.sampleInFlight.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sampleInFlight = null;
            }
            for (DecodedImageBuffer image : this.samplesToBeRendered) {
                image.release();
            }
            this.samplesToBeRendered.clear();
            this.wantsFrame.set(true);
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.renderExecutor.submit(latch::countDown);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void setPresentationTimestampPlug(long timestampUs) {
        this.presentationTimestampPlug = timestampUs;
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        boolean invokeRenderImmediately = this.samplesToBeRendered.isEmpty() && this.sampleInFlight == null;
        try {
            this.renderExecutor.submit(() -> {
                this.eglManager.currentCall(() -> {
                    try (Performance.Trackable capture = this.performanceMonitor.time("capture");){
                        surfaceTexture.updateTexImage();
                        surfaceTexture.getTransformMatrix(this.textureExternal.transform);
                        this.textureExternal.setPresentationTimestamp(surfaceTexture.getTimestamp());
                    }
                }, this.outputRenderSurface.eglSurface);
                if (invokeRenderImmediately) {
                    this.onFrameRendered(this.textureExternal.id, this.textureExternal.targetType, this.textureExternal.presentationTimestamp);
                } else {
                    this.renderExecutor.submit(() -> this.onFrameRendered(this.textureExternal.id, this.textureExternal.targetType, this.textureExternal.presentationTimestamp));
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.renderNextSample(null);
    }

    synchronized void renderNextSample(@Nullable DecodedImageBuffer next) {
        if (this.paused.get()) {
            if (next != null) {
                next.release();
            }
            return;
        }
        if (next != null) {
            this.samplesToBeRendered.add(next);
        }
        if (!this.samplesToBeRendered.isEmpty() && (this.presentationTimestampPlug < 0L || Objects.requireNonNull(this.samplesToBeRendered.peek()).presentationTimeUs <= this.presentationTimestampPlug) && this.wantsFrame.compareAndSet(true, false)) {
            DecodedImageBuffer sample = this.samplesToBeRendered.remove();
            Callable<DecodedImageBuffer> C = () -> {
                this.eglManager.currentCall(() -> {
                    try {
                        if (!sample.render()) {
                            this.wantsFrame.set(true);
                        }
                    }
                    catch (Exception e) {
                        this.wantsFrame.set(true);
                        Log.e((String)"VideoFrameTransformer", (String)("Sample.render failed: " + e));
                    }
                }, this.outputRenderSurface.eglSurface);
                sample.release();
                return sample;
            };
            this.sampleInFlight = this.renderExecutor.submit(C);
        } else if (this.sampleInFlight != null && (this.sampleInFlight.isDone() || this.sampleInFlight.isCancelled())) {
            this.sampleInFlight = null;
            this.wantsFrame.set(true);
        }
    }

    @Override
    public void release() {
        this.flush();
        this.wantsFrame.set(false);
        this.renderExecutor.shutdown();
        try {
            this.renderExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.errorCallback.accept(new RuntimeException(e.getMessage()));
        }
        this.eglManager.currentCall(() -> {
            this.samplesToBeRendered.clear();
            if (this.surfaceTexture != null) {
                this.surfaceTexture.release();
            }
            if (this.textureExternal != null) {
                this.textureExternal.release();
            }
            if (this.textureExternalShader != null) {
                this.textureExternalShader.release();
            }
        }, this.offscreenSurface);
        if (this.outputRenderSurface != null) {
            this.outputRenderSurface.release();
        }
        this.eglManager.releaseSurface(this.offscreenSurface);
        this.renderHandler.getLooper().quitSafely();
    }
}

