/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.IRepeatableInputStream;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.io.RepeatableInputStream;

public class RepeatableRequestEntity
implements RequestEntity {
    private final Log log = LogFactory.getLog((Class)RepeatableRequestEntity.class);
    private InputStream is = null;
    private String contentType = null;
    private long contentLength = 0L;
    int bytesWritten = 0;
    private IRepeatableInputStream repeatableInputStream = null;
    private ProgressMonitoredInputStream progressMonitoredIS = null;

    public RepeatableRequestEntity(InputStream is, String contentType, long contentLength) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.is = is;
        this.contentLength = contentLength;
        this.contentType = contentType;
        InputStream inputStream = is;
        while (inputStream instanceof InputStreamWrapper) {
            if (inputStream instanceof ProgressMonitoredInputStream) {
                this.progressMonitoredIS = (ProgressMonitoredInputStream)inputStream;
            }
            if (inputStream instanceof IRepeatableInputStream) {
                this.repeatableInputStream = (IRepeatableInputStream)((Object)inputStream);
            }
            inputStream = ((InputStreamWrapper)((Object)inputStream)).getWrappedInputStream();
        }
        if (this.repeatableInputStream == null) {
            this.log.debug((Object)"Wrapping non-repeatable input stream in a RepeatableInputStream");
            this.is = new RepeatableInputStream(is);
            this.repeatableInputStream = (IRepeatableInputStream)((Object)this.is);
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        if (this.bytesWritten > 0) {
            this.repeatableInputStream.repeatInputStream();
            this.log.warn((Object)("Repeating transmission of " + this.bytesWritten + " bytes"));
            if (this.progressMonitoredIS != null) {
                this.progressMonitoredIS.sendNotificationUpdate(0 - this.bytesWritten);
            }
            this.bytesWritten = 0;
        }
        byte[] tmp = new byte[8192];
        int count = 0;
        while ((count = this.is.read(tmp)) >= 0) {
            this.bytesWritten += count;
            out.write(tmp, 0, count);
        }
    }
}

