/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.InputStream;
import org.jets3t.service.io.BytesTransferredWatcher;
import org.jets3t.service.io.InputStreamWrapper;

public class ProgressMonitoredInputStream
extends InputStream
implements InputStreamWrapper {
    private InputStream inputStream = null;
    private BytesTransferredWatcher bytesTransferredWatcher = null;
    private long minimumBytesBeforeNotification = 1024L;
    private long bytesTransferredTotal = 0L;
    private long bytesTransferredLastUpdate = 0L;

    public ProgressMonitoredInputStream(InputStream inputStream, BytesTransferredWatcher bytesTransferredWatcher, long minimumBytesBeforeNotification) {
        if (inputStream == null) {
            throw new IllegalArgumentException("ProgressMonitoredInputStream cannot run with a null InputStream");
        }
        this.inputStream = inputStream;
        this.bytesTransferredWatcher = bytesTransferredWatcher;
        this.minimumBytesBeforeNotification = minimumBytesBeforeNotification;
    }

    public ProgressMonitoredInputStream(InputStream inputStream, BytesTransferredWatcher bytesTransferredWatcher) {
        this(inputStream, bytesTransferredWatcher, 1024L);
    }

    public void sendNotificationUpdate(long bytesTransmitted) {
        long bytesSinceLastUpdate;
        this.bytesTransferredTotal += bytesTransmitted;
        if (this.bytesTransferredWatcher != null && ((bytesSinceLastUpdate = this.bytesTransferredTotal - this.bytesTransferredLastUpdate) > this.minimumBytesBeforeNotification || bytesSinceLastUpdate < 0L)) {
            this.bytesTransferredWatcher.bytesTransferredUpdate(bytesSinceLastUpdate);
            this.bytesTransferredLastUpdate = this.bytesTransferredTotal;
        }
    }

    public int read() throws IOException {
        int read = this.inputStream.read();
        if (read != -1) {
            this.sendNotificationUpdate(1L);
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.read(b, off, len);
        if (read != -1) {
            this.sendNotificationUpdate(read);
        }
        return read;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

