/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.IRepeatableInputStream;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.UnrecoverableIOException;

public class RepeatableFileInputStream
extends InputStream
implements IRepeatableInputStream,
InputStreamWrapper {
    private final Log log = LogFactory.getLog((Class)RepeatableFileInputStream.class);
    private File file = null;
    private FileInputStream fis = null;
    private int bytesReadTotal = 0;

    public RepeatableFileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.fis = new FileInputStream(file);
        this.file = file;
    }

    public void repeatInputStream() throws IOException {
        try {
            this.fis.close();
            this.fis = new FileInputStream(this.file);
            this.log.debug((Object)("Reset after returning " + this.bytesReadTotal + " bytes"));
            this.bytesReadTotal = 0;
        }
        catch (IOException e) {
            throw new UnrecoverableIOException("Input stream is not repeatable: " + e.getMessage());
        }
    }

    public int available() throws IOException {
        return this.fis.available();
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public int read() throws IOException {
        int byteRead = this.fis.read();
        if (byteRead != -1) {
            ++this.bytesReadTotal;
            return byteRead;
        }
        return -1;
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int count = this.fis.read(arg0, arg1, arg2);
        this.bytesReadTotal += count;
        return count;
    }

    public InputStream getWrappedInputStream() {
        return this.fis;
    }
}

