/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class CreateObjectsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private CreateObjectsEvent(int eventCode) {
        super(eventCode);
    }

    public static CreateObjectsEvent newErrorEvent(Throwable t) {
        CreateObjectsEvent event = new CreateObjectsEvent(0);
        event.setErrorCause(t);
        return event;
    }

    public static CreateObjectsEvent newStartedEvent(ThreadWatcher threadWatcher) {
        CreateObjectsEvent event = new CreateObjectsEvent(1);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static CreateObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects) {
        CreateObjectsEvent event = new CreateObjectsEvent(3);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static CreateObjectsEvent newCompletedEvent() {
        CreateObjectsEvent event = new CreateObjectsEvent(2);
        return event;
    }

    public static CreateObjectsEvent newCancelledEvent(S3Object[] incompletedObjects) {
        CreateObjectsEvent event = new CreateObjectsEvent(4);
        event.setObjects(incompletedObjects);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getCreatedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Created Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

