/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.GZipInflatingOutputStream;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.EncryptionUtil;

public class DownloadPackage {
    private static final Log log = LogFactory.getLog((Class)DownloadPackage.class);
    private S3Object object = null;
    private File outputFile = null;
    private boolean isUnzipping = false;
    private EncryptionUtil encryptionUtil = null;

    public DownloadPackage(S3Object object, File outputFile) {
        this(object, outputFile, false, null);
    }

    public DownloadPackage(S3Object object, File outputFile, boolean isUnzipping, EncryptionUtil encryptionUtil) {
        this.object = object;
        this.outputFile = outputFile;
        this.isUnzipping = isUnzipping;
        this.encryptionUtil = encryptionUtil;
    }

    public S3Object getObject() {
        return this.object;
    }

    public OutputStream getOutputStream() throws Exception {
        OutputStream outputStream = new FileOutputStream(this.outputFile);
        if (this.isUnzipping) {
            log.debug((Object)("Inflating gzipped data for object: " + this.object.getKey()));
            outputStream = new GZipInflatingOutputStream(outputStream);
        }
        if (this.encryptionUtil != null) {
            log.debug((Object)("Decrypting encrypted data for object: " + this.object.getKey()));
            outputStream = this.encryptionUtil.decrypt(outputStream);
        }
        return outputStream;
    }
}

