/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class GetObjectsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private GetObjectsEvent(int eventCode) {
        super(eventCode);
    }

    public static GetObjectsEvent newErrorEvent(Throwable t) {
        GetObjectsEvent event = new GetObjectsEvent(0);
        event.setErrorCause(t);
        return event;
    }

    public static GetObjectsEvent newStartedEvent(ThreadWatcher threadWatcher) {
        GetObjectsEvent event = new GetObjectsEvent(1);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static GetObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects) {
        GetObjectsEvent event = new GetObjectsEvent(3);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static GetObjectsEvent newCompletedEvent() {
        GetObjectsEvent event = new GetObjectsEvent(2);
        return event;
    }

    public static GetObjectsEvent newCancelledEvent(S3Object[] incompletedObjects) {
        GetObjectsEvent event = new GetObjectsEvent(4);
        event.setObjects(incompletedObjects);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getCompletedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

