/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.io.BytesTransferredWatcher;
import org.jets3t.service.io.InterruptableInputStream;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.CancelEventTrigger;
import org.jets3t.service.multithread.CreateBucketsEvent;
import org.jets3t.service.multithread.CreateObjectsEvent;
import org.jets3t.service.multithread.DeleteObjectsEvent;
import org.jets3t.service.multithread.DownloadObjectsEvent;
import org.jets3t.service.multithread.DownloadPackage;
import org.jets3t.service.multithread.GetObjectHeadsEvent;
import org.jets3t.service.multithread.GetObjectsEvent;
import org.jets3t.service.multithread.LookupACLEvent;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;
import org.jets3t.service.multithread.UpdateACLEvent;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.signedurl.SignedUrlAndObject;
import org.jets3t.service.utils.signedurl.SignedUrlHandler;

public class S3ServiceMulti
implements Serializable {
    private static final long serialVersionUID = -1031831146656816336L;
    private final Log log = LogFactory.getLog((Class)S3ServiceMulti.class);
    private S3Service s3Service = null;
    private ArrayList serviceEventListeners = new ArrayList();
    private final long sleepTime;
    static /* synthetic */ Class class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager;

    public S3ServiceMulti(S3Service s3Service, S3ServiceEventListener listener) {
        this(s3Service, listener, 200L);
    }

    public S3ServiceMulti(S3Service s3Service, S3ServiceEventListener listener, long threadSleepTimeMS) {
        this.s3Service = s3Service;
        this.addServiceEventListener(listener);
        this.sleepTime = threadSleepTimeMS;
    }

    public S3Service getS3Service() {
        return this.s3Service;
    }

    public void addServiceEventListener(S3ServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.add(listener);
        }
    }

    public void removeServiceEventListener(S3ServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.remove(listener);
        }
    }

    protected void fireServiceEvent(ServiceEvent event) {
        if (this.serviceEventListeners.size() == 0) {
            this.log.warn((Object)"S3ServiceMulti invoked without any S3ServiceEventListener objects, this is dangerous!");
        }
        Iterator listenerIter = this.serviceEventListeners.iterator();
        while (listenerIter.hasNext()) {
            S3ServiceEventListener listener = (S3ServiceEventListener)listenerIter.next();
            if (event instanceof CreateObjectsEvent) {
                listener.s3ServiceEventPerformed((CreateObjectsEvent)event);
                continue;
            }
            if (event instanceof CreateBucketsEvent) {
                listener.s3ServiceEventPerformed((CreateBucketsEvent)event);
                continue;
            }
            if (event instanceof DeleteObjectsEvent) {
                listener.s3ServiceEventPerformed((DeleteObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectsEvent) {
                listener.s3ServiceEventPerformed((GetObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectHeadsEvent) {
                listener.s3ServiceEventPerformed((GetObjectHeadsEvent)event);
                continue;
            }
            if (event instanceof LookupACLEvent) {
                listener.s3ServiceEventPerformed((LookupACLEvent)event);
                continue;
            }
            if (event instanceof UpdateACLEvent) {
                listener.s3ServiceEventPerformed((UpdateACLEvent)event);
                continue;
            }
            if (event instanceof DownloadObjectsEvent) {
                listener.s3ServiceEventPerformed((DownloadObjectsEvent)event);
                continue;
            }
            throw new IllegalArgumentException("Listener not invoked for event class: " + event.getClass());
        }
    }

    public boolean isAuthenticatedConnection() {
        return this.s3Service.isAuthenticatedConnection();
    }

    public AWSCredentials getAWSCredentials() {
        return this.s3Service.getAWSCredentials();
    }

    public void createBuckets(S3Bucket[] buckets) {
        final ArrayList<S3Bucket> incompletedBucketList = new ArrayList<S3Bucket>();
        AbstractRunnable[] runnables = new CreateBucketRunnable[buckets.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedBucketList.add(buckets[i]);
            runnables[i] = new CreateBucketRunnable(buckets[i]);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedBucketList.removeAll(completedResults);
                S3Bucket[] completedBuckets = completedResults.toArray(new S3Bucket[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newInProgressEvent(threadWatcher, completedBuckets));
            }

            public void fireCancelEvent() {
                S3Bucket[] incompletedBuckets = incompletedBucketList.toArray(new S3Bucket[incompletedBucketList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newCancelledEvent(incompletedBuckets));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void putObjects(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        final long bytesTotal = ServiceUtils.countBytesInObjects(objects);
        final long[] bytesCompleted = new long[]{0L};
        BytesTransferredWatcher bytesTransferredListener = new BytesTransferredWatcher(){

            public void bytesTransferredUpdate(long transferredBytes) {
                bytesCompleted[0] = bytesCompleted[0] + transferredBytes;
            }
        };
        AbstractRunnable[] runnables = new CreateObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(objects[i]);
            runnables[i] = new CreateObjectRunnable(bucket, objects[i], bytesTransferredListener);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                threadWatcher.setBytesTransferredInfo(bytesCompleted[0], bytesTotal);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                threadWatcher.setBytesTransferredInfo(bytesCompleted[0], bytesTotal);
                incompletedObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void deleteObjects(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> objectsToDeleteList = new ArrayList<S3Object>();
        AbstractRunnable[] runnables = new DeleteObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            objectsToDeleteList.add(objects[i]);
            runnables[i] = new DeleteObjectRunnable(bucket, objects[i]);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                S3Object[] deletedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects));
            }

            public void fireCancelEvent() {
                S3Object[] remainingObjects = objectsToDeleteList.toArray(new S3Object[objectsToDeleteList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void getObjects(S3Bucket bucket, S3Object[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        this.getObjects(bucket, objectKeys);
    }

    public void getObjects(S3Bucket bucket, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucket, objectKeys[i], false);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void getObjectsHeads(S3Bucket bucket, S3Object[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        this.getObjectsHeads(bucket, objectKeys);
    }

    public void getObjectsHeads(S3Bucket bucket, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucket, objectKeys[i], true);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void getObjectACLs(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        AbstractRunnable[] runnables = new GetACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new GetACLRunnable(bucket, objects[i]);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCancelledEvent(cancelledObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void putACLs(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        AbstractRunnable[] runnables = new PutACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new PutACLRunnable(bucket, objects[i]);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCancelledEvent(cancelledObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void downloadObjects(S3Bucket bucket, DownloadPackage[] downloadPackages) {
        final long[] bytesCompleted = new long[]{0L};
        BytesTransferredWatcher bytesTransferredListener = new BytesTransferredWatcher(){

            public void bytesTransferredUpdate(long transferredBytes) {
                bytesCompleted[0] = bytesCompleted[0] + transferredBytes;
            }
        };
        final ArrayList<S3Object> incompleteObjectDownloadList = new ArrayList<S3Object>();
        AbstractRunnable[] runnables = new DownloadObjectRunnable[downloadPackages.length];
        S3Object[] objects = new S3Object[downloadPackages.length];
        for (int i = 0; i < runnables.length; ++i) {
            objects[i] = downloadPackages[i].getObject();
            incompleteObjectDownloadList.add(objects[i]);
            runnables[i] = new DownloadObjectRunnable(bucket, objects[i].getKey(), downloadPackages[i], bytesTransferredListener);
        }
        final long bytesTotal = ServiceUtils.countBytesInObjects(objects);
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                threadWatcher.setBytesTransferredInfo(bytesCompleted[0], bytesTotal);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompleteObjectDownloadList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                threadWatcher.setBytesTransferredInfo(bytesCompleted[0], bytesTotal);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                S3Object[] incompleteObjects = incompleteObjectDownloadList.toArray(new S3Object[incompleteObjectDownloadList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCancelledEvent(incompleteObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void getObjects(String[] signedGetURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjects(String[] signedGetURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        AbstractRunnable[] runnables = new GetObjectRunnable[signedGetURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedGetURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromPath(url.getPath());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetObjectRunnable(signedGetURLs[i], false);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void getObjectsHeads(String[] signedHeadURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjectsHeads(String[] signedHeadURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        AbstractRunnable[] runnables = new GetObjectRunnable[signedHeadURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedHeadURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromPath(url.getPath());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetObjectRunnable(signedHeadURLs[i], true);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void deleteObjects(String[] signedDeleteUrls) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method deleteObjects(String[] signedDeleteURLs) available");
        }
        final ArrayList<S3Object> objectsToDeleteList = new ArrayList<S3Object>();
        AbstractRunnable[] runnables = new DeleteObjectRunnable[signedDeleteUrls.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedDeleteUrls[i]);
            S3Object object = ServiceUtils.buildObjectFromPath(url.getPath());
            objectsToDeleteList.add(object);
            runnables[i] = new DeleteObjectRunnable(signedDeleteUrls[i]);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                S3Object[] deletedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects));
            }

            public void fireCancelEvent() {
                S3Object[] remainingObjects = objectsToDeleteList.toArray(new S3Object[objectsToDeleteList.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    public void putObjects(SignedUrlAndObject[] signedPutUrlAndObjects) {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method putObjects(SignedUrlAndObject[] signedPutUrlAndObjects) available");
        }
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        final long[] bytesCompleted = new long[]{0L};
        S3Object[] objects = new S3Object[signedPutUrlAndObjects.length];
        for (int i = 0; i < signedPutUrlAndObjects.length; ++i) {
            objects[i] = signedPutUrlAndObjects[i].getObject();
        }
        final long bytesTotal = ServiceUtils.countBytesInObjects(objects);
        BytesTransferredWatcher bytesTransferredListener = new BytesTransferredWatcher(){

            public void bytesTransferredUpdate(long transferredBytes) {
                bytesCompleted[0] = bytesCompleted[0] + transferredBytes;
            }
        };
        AbstractRunnable[] runnables = new SignedPutRunnable[signedPutUrlAndObjects.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(signedPutUrlAndObjects[i].getObject());
            runnables[i] = new SignedPutRunnable(signedPutUrlAndObjects[i], bytesTransferredListener);
        }
        new ThreadGroupManager(runnables){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                threadWatcher.setBytesTransferredInfo(bytesCompleted[0], bytesTotal);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                threadWatcher.setBytesTransferredInfo(bytesCompleted[0], bytesTotal);
                incompletedObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects));
            }

            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects));
            }

            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent());
            }

            public void fireErrorEvent(Throwable throwable) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable));
            }
        }.run();
    }

    private abstract class ThreadGroupManager {
        private final Log log = LogFactory.getLog((Class)(class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager == null ? (class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager = S3ServiceMulti.class$("org.jets3t.service.multithread.S3ServiceMulti$ThreadGroupManager")) : class$org$jets3t$service$multithread$S3ServiceMulti$ThreadGroupManager));
        private final int MaxThreadCount = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.max-thread-count", 4);
        private AbstractRunnable[] runnables = null;
        private Thread[] threads = null;
        private boolean[] started = null;
        private boolean[] alreadyFired = null;

        public ThreadGroupManager(AbstractRunnable[] runnables) {
            this.runnables = runnables;
            this.threads = new Thread[runnables.length];
            this.started = new boolean[runnables.length];
            this.alreadyFired = new boolean[runnables.length];
        }

        private List getNewlyCompletedResults() throws Throwable {
            ArrayList<Object> completedResults = new ArrayList<Object>();
            for (int i = 0; i < this.threads.length; ++i) {
                if (this.alreadyFired[i] || !this.started[i] || this.threads[i].isAlive()) continue;
                this.alreadyFired[i] = true;
                this.log.debug((Object)("Thread " + (i + 1) + " of " + this.threads.length + " has recently completed, releasing resources"));
                if (this.runnables[i].getResult() instanceof Throwable) {
                    Throwable throwable = (Throwable)this.runnables[i].getResult();
                    this.runnables[i] = null;
                    this.threads[i] = null;
                    throw throwable;
                }
                completedResults.add(this.runnables[i].getResult());
                this.runnables[i] = null;
                this.threads[i] = null;
            }
            return completedResults;
        }

        private void startPendingThreads() throws Throwable {
            int i;
            int runningThreadCount = 0;
            for (i = 0; i < this.runnables.length; ++i) {
                if (!this.started[i] || this.alreadyFired[i]) continue;
                ++runningThreadCount;
            }
            for (i = 0; runningThreadCount < this.MaxThreadCount && i < this.started.length; ++i) {
                if (this.started[i]) continue;
                this.threads[i] = new Thread(this.runnables[i]);
                this.threads[i].start();
                this.started[i] = true;
                ++runningThreadCount;
                this.log.debug((Object)("Thread " + (i + 1) + " of " + this.runnables.length + " has started"));
            }
        }

        private int getPendingThreadCount() {
            int pendingThreadCount = 0;
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.alreadyFired[i]) continue;
                ++pendingThreadCount;
            }
            return pendingThreadCount;
        }

        private void forceInterruptAllRunnables() {
            this.log.debug((Object)"Setting force interrupt flag on all runnables");
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.runnables[i] == null) continue;
                this.runnables[i].forceInterrupt();
                this.runnables[i] = null;
            }
        }

        public void run() {
            this.log.debug((Object)"Started ThreadManager");
            final boolean[] interrupted = new boolean[]{false};
            CancelEventTrigger cancelEventTrigger = new CancelEventTrigger(){
                private static final long serialVersionUID = 6328417466929608235L;

                public void cancelTask(Object eventSource) {
                    ThreadGroupManager.this.log.debug((Object)"Cancel task invoked on ThreadManager");
                    interrupted[0] = true;
                    ThreadGroupManager.this.forceInterruptAllRunnables();
                }
            };
            try {
                List completedResults;
                int completedThreads;
                this.startPendingThreads();
                ThreadWatcher threadWatcher = new ThreadWatcher();
                threadWatcher.setThreadsCompletedRatio(0L, this.runnables.length, cancelEventTrigger);
                this.fireStartEvent(threadWatcher);
                while (!interrupted[0] && this.getPendingThreadCount() > 0) {
                    try {
                        Thread.sleep(S3ServiceMulti.this.sleepTime);
                        if (interrupted[0]) continue;
                        completedThreads = this.runnables.length - this.getPendingThreadCount();
                        threadWatcher.setThreadsCompletedRatio(completedThreads, this.runnables.length, cancelEventTrigger);
                        completedResults = this.getNewlyCompletedResults();
                        this.fireProgressEvent(threadWatcher, completedResults);
                        this.startPendingThreads();
                    }
                    catch (InterruptedException e) {
                        interrupted[0] = true;
                        this.forceInterruptAllRunnables();
                    }
                }
                if (interrupted[0]) {
                    this.fireCancelEvent();
                } else {
                    completedThreads = this.runnables.length - this.getPendingThreadCount();
                    threadWatcher.setThreadsCompletedRatio(completedThreads, this.runnables.length, cancelEventTrigger);
                    completedResults = this.getNewlyCompletedResults();
                    this.fireProgressEvent(threadWatcher, completedResults);
                    if (completedResults.size() > 0) {
                        this.log.debug((Object)(completedResults.size() + " threads have recently completed"));
                    }
                    this.fireCompletedEvent();
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"A thread failed with an exception. Firing ERROR event and cancelling all threads", t);
                this.forceInterruptAllRunnables();
                this.fireErrorEvent(t);
            }
        }

        public abstract void fireStartEvent(ThreadWatcher var1);

        public abstract void fireProgressEvent(ThreadWatcher var1, List var2);

        public abstract void fireCompletedEvent();

        public abstract void fireCancelEvent();

        public abstract void fireErrorEvent(Throwable var1);
    }

    private class SignedPutRunnable
    extends AbstractRunnable {
        private SignedUrlAndObject signedUrlAndObject;
        private InterruptableInputStream interruptableInputStream;
        private BytesTransferredWatcher bytesTransferredListener;
        private Object result;

        public SignedPutRunnable(SignedUrlAndObject signedUrlAndObject, BytesTransferredWatcher bytesTransferredListener) {
            this.signedUrlAndObject = null;
            this.interruptableInputStream = null;
            this.bytesTransferredListener = null;
            this.result = null;
            this.signedUrlAndObject = signedUrlAndObject;
            this.bytesTransferredListener = bytesTransferredListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.signedUrlAndObject.getObject().getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.signedUrlAndObject.getObject().getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.bytesTransferredListener);
                    this.signedUrlAndObject.getObject().setDataInputStream(pmInputStream);
                }
                SignedUrlHandler signedPutUploader = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                this.result = signedPutUploader.putObjectWithSignedUrl(this.signedUrlAndObject.getSignedUrl(), this.signedUrlAndObject.getObject());
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
            finally {
                try {
                    this.signedUrlAndObject.getObject().closeDataInputStream();
                }
                catch (IOException e) {
                    S3ServiceMulti.this.log.error((Object)"Unable to close Object's input stream", (Throwable)e);
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class DownloadObjectRunnable
    extends AbstractRunnable {
        private String objectKey;
        private S3Bucket bucket;
        private DownloadPackage downloadPackage;
        private InterruptableInputStream interruptableInputStream;
        private BytesTransferredWatcher bytesTransferredListener;
        private Object result;

        public DownloadObjectRunnable(S3Bucket bucket, String objectKey, DownloadPackage downloadPackage, BytesTransferredWatcher bytesTransferredListener) {
            this.objectKey = null;
            this.bucket = null;
            this.downloadPackage = null;
            this.interruptableInputStream = null;
            this.bytesTransferredListener = null;
            this.result = null;
            this.bucket = bucket;
            this.objectKey = objectKey;
            this.downloadPackage = downloadPackage;
            this.bytesTransferredListener = bytesTransferredListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream bufferedOutputStream = null;
            S3Object object = null;
            try {
                object = S3ServiceMulti.this.s3Service.getObject(this.bucket, this.objectKey);
                this.interruptableInputStream = new InterruptableInputStream(object.getDataInputStream());
                bufferedInputStream = new BufferedInputStream(new ProgressMonitoredInputStream(this.interruptableInputStream, this.bytesTransferredListener));
                bufferedOutputStream = new BufferedOutputStream(this.downloadPackage.getOutputStream());
                try {
                    byte[] buffer = new byte[1024];
                    int byteCount = -1;
                    while ((byteCount = bufferedInputStream.read(buffer)) != -1) {
                        ((BufferedOutputStream)bufferedOutputStream).write(buffer, 0, byteCount);
                    }
                }
                finally {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                object.setDataInputStream(null);
                this.result = object;
            }
            catch (Throwable t) {
                this.result = t;
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception e) {
                        S3ServiceMulti.this.log.error((Object)"Unable to close Object input stream", (Throwable)e);
                    }
                }
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (Exception e) {
                        S3ServiceMulti.this.log.error((Object)"Unable to close download output stream", (Throwable)e);
                    }
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class GetObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private String objectKey;
        private String signedGetOrHeadUrl;
        private boolean headOnly;
        private Object result;

        public GetObjectRunnable(S3Bucket bucket, String objectKey, boolean headOnly) {
            this.bucket = null;
            this.objectKey = null;
            this.signedGetOrHeadUrl = null;
            this.headOnly = false;
            this.result = null;
            this.signedGetOrHeadUrl = null;
            this.bucket = bucket;
            this.objectKey = objectKey;
            this.headOnly = headOnly;
        }

        public GetObjectRunnable(String signedGetOrHeadUrl, boolean headOnly) {
            this.bucket = null;
            this.objectKey = null;
            this.signedGetOrHeadUrl = null;
            this.headOnly = false;
            this.result = null;
            this.signedGetOrHeadUrl = signedGetOrHeadUrl;
            this.bucket = null;
            this.objectKey = null;
            this.headOnly = headOnly;
        }

        public void run() {
            try {
                if (this.headOnly) {
                    if (this.signedGetOrHeadUrl == null) {
                        this.result = S3ServiceMulti.this.s3Service.getObjectDetails(this.bucket, this.objectKey);
                    } else {
                        SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                        this.result = handler.getObjectDetailsWithSignedUrl(this.signedGetOrHeadUrl);
                    }
                } else if (this.signedGetOrHeadUrl == null) {
                    this.result = S3ServiceMulti.this.s3Service.getObject(this.bucket, this.objectKey);
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    this.result = handler.getObjectWithSignedUrl(this.signedGetOrHeadUrl);
                }
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class CreateObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object s3Object;
        private InterruptableInputStream interruptableInputStream;
        private BytesTransferredWatcher bytesTransferredListener;
        private Object result;

        public CreateObjectRunnable(S3Bucket bucket, S3Object s3Object, BytesTransferredWatcher bytesTransferredListener) {
            this.bucket = null;
            this.s3Object = null;
            this.interruptableInputStream = null;
            this.bytesTransferredListener = null;
            this.result = null;
            this.bucket = bucket;
            this.s3Object = s3Object;
            this.bytesTransferredListener = bytesTransferredListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.s3Object.getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.s3Object.getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.bytesTransferredListener);
                    this.s3Object.setDataInputStream(pmInputStream);
                }
                this.result = S3ServiceMulti.this.s3Service.putObject(this.bucket, this.s3Object);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
            finally {
                try {
                    this.s3Object.closeDataInputStream();
                }
                catch (IOException e) {
                    S3ServiceMulti.this.log.error((Object)"Unable to close Object's input stream", (Throwable)e);
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class CreateBucketRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private Object result;

        public CreateBucketRunnable(S3Bucket bucket) {
            this.bucket = null;
            this.result = null;
            this.bucket = bucket;
        }

        public void run() {
            try {
                this.result = S3ServiceMulti.this.s3Service.createBucket(this.bucket);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class DeleteObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object object;
        private String signedDeleteUrl;
        private Object result;

        public DeleteObjectRunnable(S3Bucket bucket, S3Object object) {
            this.bucket = null;
            this.object = null;
            this.signedDeleteUrl = null;
            this.result = null;
            this.signedDeleteUrl = null;
            this.bucket = bucket;
            this.object = object;
        }

        public DeleteObjectRunnable(String signedDeleteUrl) {
            this.bucket = null;
            this.object = null;
            this.signedDeleteUrl = null;
            this.result = null;
            this.signedDeleteUrl = signedDeleteUrl;
            this.bucket = null;
            this.object = null;
        }

        public void run() {
            try {
                if (this.signedDeleteUrl == null) {
                    S3ServiceMulti.this.s3Service.deleteObject(this.bucket, this.object.getKey());
                    this.result = this.object;
                } else {
                    SignedUrlHandler handler = (SignedUrlHandler)((Object)S3ServiceMulti.this.s3Service);
                    handler.deleteObjectWithSignedUrl(this.signedDeleteUrl);
                    URL url = new URL(this.signedDeleteUrl);
                    this.result = ServiceUtils.buildObjectFromPath(url.getPath());
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class GetACLRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object object;
        private Object result;

        public GetACLRunnable(S3Bucket bucket, S3Object object) {
            this.bucket = null;
            this.object = null;
            this.result = null;
            this.bucket = bucket;
            this.object = object;
        }

        public void run() {
            try {
                AccessControlList acl = S3ServiceMulti.this.s3Service.getObjectAcl(this.bucket, this.object.getKey());
                this.object.setAcl(acl);
                this.result = this.object;
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class PutACLRunnable
    extends AbstractRunnable {
        private S3Bucket bucket;
        private S3Object s3Object;
        private Object result;

        public PutACLRunnable(S3Bucket bucket, S3Object s3Object) {
            this.bucket = null;
            this.s3Object = null;
            this.result = null;
            this.bucket = bucket;
            this.s3Object = s3Object;
        }

        public void run() {
            try {
                if (this.s3Object == null) {
                    S3ServiceMulti.this.s3Service.putBucketAcl(this.bucket);
                } else {
                    S3ServiceMulti.this.s3Service.putObjectAcl(this.bucket, this.s3Object);
                }
                this.result = this.s3Object;
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private abstract class AbstractRunnable
    implements Runnable {
        private boolean forceInterrupt = false;

        private AbstractRunnable() {
        }

        public abstract Object getResult();

        public abstract void forceInterruptCalled();

        protected void forceInterrupt() {
            this.forceInterrupt = true;
            this.forceInterruptCalled();
        }

        protected boolean notInterrupted() throws InterruptedException {
            if (this.forceInterrupt || Thread.interrupted()) {
                throw new InterruptedException("Interrupted by JAMES");
            }
            return true;
        }
    }
}

