/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jets3t.service.S3ServiceException;

public class RestUtils {
    public static final List HTTP_HEADER_METADATA_NAMES = Arrays.asList("content-type", "content-md5", "content-length", "content-language", "expires", "cache-control", "content-disposition", "content-encoding");

    public static String encodeUrlString(String path) throws S3ServiceException {
        try {
            String encodedPath = URLEncoder.encode(path, "UTF8");
            encodedPath = encodedPath.replaceAll("\\+", "%20");
            return encodedPath;
        }
        catch (UnsupportedEncodingException uee) {
            throw new S3ServiceException("Unable to encode path: " + path, uee);
        }
    }

    public static String encodeUrlPath(String path, String delimiter) throws S3ServiceException {
        StringBuffer result = new StringBuffer();
        String[] tokens = path.split(delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            result.append(RestUtils.encodeUrlString(tokens[i]));
            if (i >= tokens.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String makeCanonicalString(String method, String resource, Map headersMap, String expires) {
        Object value;
        Object key;
        Map.Entry entry;
        StringBuffer buf = new StringBuffer();
        buf.append(method + "\n");
        TreeMap interestingHeaders = new TreeMap();
        if (headersMap != null && headersMap.size() > 0) {
            Iterator headerIter = headersMap.entrySet().iterator();
            while (headerIter.hasNext()) {
                String lk;
                entry = headerIter.next();
                key = entry.getKey();
                value = entry.getValue();
                if (key == null || !(lk = key.toString().toLowerCase(Locale.getDefault())).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith("x-amz-")) continue;
                interestingHeaders.put(lk, value);
            }
        }
        if (interestingHeaders.containsKey("x-amz-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        Iterator i = interestingHeaders.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            key = (String)entry.getKey();
            value = entry.getValue();
            if (((String)key).startsWith("x-amz-")) {
                buf.append((String)key).append(':').append(value);
            } else {
                buf.append(value);
            }
            buf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            buf.append(resource);
        } else {
            buf.append(resource.substring(0, queryIndex));
        }
        if (resource.matches(".*[&?]acl($|=|&).*")) {
            buf.append("?acl");
        } else if (resource.matches(".*[&?]torrent($|=|&).*")) {
            buf.append("?torrent");
        } else if (resource.matches(".*[&?]logging($|=|&).*")) {
            buf.append("?logging");
        }
        return buf.toString();
    }

    public static Map renameMetadataKeys(Map metadata) {
        HashMap convertedMetadata = new HashMap();
        if (metadata != null) {
            Iterator metaDataIter = metadata.entrySet().iterator();
            while (metaDataIter.hasNext()) {
                Map.Entry entry = metaDataIter.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (!HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.getDefault())) && !key.startsWith("x-amz-")) {
                    key = "x-amz-meta-" + key;
                }
                convertedMetadata.put(key, value);
            }
        }
        return convertedMetadata;
    }
}

