/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

public class TimeFormatter {
    public String formatTime(long seconds) {
        return this.formatTime(seconds, true);
    }

    public String formatTime(long seconds, boolean useUnicodeChars) {
        int hours = 0;
        if (seconds > 3600L) {
            hours = (int)seconds / 3600;
            seconds -= (long)hours * 3600L;
        }
        int mins = (int)seconds / 60;
        seconds -= (long)mins * 60L;
        if (hours > 0) {
            if (mins > 45) {
                return hours + 1 + " hours";
            }
            if (mins > 30) {
                if (useUnicodeChars) {
                    return hours + "\u00be hours";
                }
                return hours + " 3/4 hours";
            }
            if (mins > 15) {
                if (useUnicodeChars) {
                    return hours + "\u00bd hours";
                }
                return hours + " 1/2 hours";
            }
            if (mins > 0) {
                if (useUnicodeChars) {
                    return hours + "\u00bc hours";
                }
                return hours + " 1/4 hours";
            }
            return hours + " hour" + (hours > 1 ? "s" : "");
        }
        if (mins > 0) {
            if (seconds > 45L) {
                return mins + 1 + " minutes";
            }
            if (seconds > 30L) {
                if (useUnicodeChars) {
                    return mins + "\u00be minutes";
                }
                return mins + " 3/4 minutes";
            }
            if (seconds > 15L) {
                if (useUnicodeChars) {
                    return mins + "\u00bd minutes";
                }
                return mins + " 1/2 minutes";
            }
            if (seconds > 0L) {
                if (useUnicodeChars) {
                    return mins + "\u00bc minutes";
                }
                return mins + " 1/4 minutes";
            }
            return mins + " minute" + (mins > 1 ? "s" : "");
        }
        return seconds + " second" + (seconds != 1L ? "s" : "");
    }
}

