/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.sql.AWSSecretsManagerDriver;
import com.amazonaws.secretsmanager.util.SQLExceptionUtils;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.util.StringUtils;

public final class AWSSecretsManagerMySQLDriver
extends AWSSecretsManagerDriver {
    public static final int ACCESS_DENIED_FOR_USER_USING_PASSWORD_TO_DATABASE = 1045;
    public static final String SUBPREFIX = "mysql";

    public AWSSecretsManagerMySQLDriver() {
    }

    public AWSSecretsManagerMySQLDriver(SecretCache cache) {
        super(cache);
    }

    public AWSSecretsManagerMySQLDriver(AWSSecretsManagerClientBuilder builder) {
        super(builder);
    }

    public AWSSecretsManagerMySQLDriver(AWSSecretsManager client) {
        super(client);
    }

    public AWSSecretsManagerMySQLDriver(SecretCacheConfiguration cacheConfig) {
        super(cacheConfig);
    }

    @Override
    public String getPropertySubprefix() {
        return SUBPREFIX;
    }

    @Override
    public boolean isExceptionDueToAuthenticationError(Exception e) {
        return SQLExceptionUtils.unwrapAndCheckForCode(e, 1045);
    }

    @Override
    public String constructUrlFromEndpointPortDatabase(String endpoint, String port, String dbname) {
        String url = "jdbc:mysql://" + endpoint;
        if (!StringUtils.isNullOrEmpty((String)port)) {
            url = url + ":" + port;
        }
        if (!StringUtils.isNullOrEmpty((String)dbname)) {
            url = url + "/" + dbname;
        }
        return url;
    }

    @Override
    public String getDefaultDriverClass() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver", false, this.getClass().getClassLoader());
            return "com.mysql.cj.jdbc.Driver";
        }
        catch (ClassNotFoundException e) {
            return "com.mysql.jdbc.Driver";
        }
    }

    static {
        AWSSecretsManagerDriver.register(new AWSSecretsManagerMySQLDriver());
    }
}

