/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.internal.RequestReader;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyRequest;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ContainerRequest;

public class JerseyAwsProxyRequestReader
extends RequestReader<AwsProxyRequest, ContainerRequest> {
    private boolean useStageAsBasePath = false;
    private static AwsProxyRequest currentRequest;
    private static Context currentLambdaContext;

    public ContainerRequest readRequest(AwsProxyRequest request, SecurityContext securityContext, Context lambdaContext) throws InvalidRequestEventException {
        URI requestPathUri;
        URI basePathUri;
        currentRequest = request;
        currentLambdaContext = lambdaContext;
        String basePath = this.useStageAsBasePath ? request.getRequestContext().getStage() : "/";
        try {
            basePathUri = new URI(basePath);
        }
        catch (URISyntaxException e) {
            throw new InvalidRequestEventException("Error while generating base path URI: " + basePath, (Exception)e);
        }
        try {
            requestPathUri = new URI(request.getQueryString() == null ? request.getPath() : request.getPath() + request.getQueryString());
        }
        catch (URISyntaxException e) {
            throw new InvalidRequestEventException("Error while generating request path URI: " + request.getPath(), (Exception)e);
        }
        MapPropertiesDelegate apiGatewayProperties = new MapPropertiesDelegate();
        apiGatewayProperties.setProperty("com.amazonaws.apigateway.request.context", (Object)request.getRequestContext());
        apiGatewayProperties.setProperty("com.amazonaws.apigateway.stage.variables", (Object)request.getStageVariables());
        apiGatewayProperties.setProperty("com.amazonaws.lambda.context", (Object)lambdaContext);
        ContainerRequest requestContext = new ContainerRequest(basePathUri, requestPathUri, request.getHttpMethod(), securityContext, (PropertiesDelegate)apiGatewayProperties);
        if (request.getBody() != null) {
            if (request.isBase64Encoded()) {
                requestContext.setEntityStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(request.getBody())));
            } else {
                requestContext.setEntityStream((InputStream)new ByteArrayInputStream(request.getBody().getBytes()));
            }
        }
        if (request.getHeaders() != null) {
            for (String headerName : request.getHeaders().keySet()) {
                requestContext.headers(headerName, new Object[]{request.getHeaders().get(headerName)});
            }
        }
        return requestContext;
    }

    public void setUseStageAsBasePath(boolean useStageAsBasePath) {
        this.useStageAsBasePath = useStageAsBasePath;
    }

    protected Class<? extends AwsProxyRequest> getRequestClass() {
        return AwsProxyRequest.class;
    }

    static AwsProxyRequest getCurrentRequest() {
        return currentRequest;
    }

    static Context getCurrentLambdaContext() {
        return currentLambdaContext;
    }
}

