/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.web.SpringServletContainerInitializer;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.DispatcherServlet;

public class SpringBootLambdaContainerHandler<RequestType, ResponseType>
extends AwsLambdaServletContainerHandler<RequestType, ResponseType, AwsProxyHttpServletRequest, AwsHttpServletResponse> {
    private final Class<? extends WebApplicationInitializer> springBootInitializer;
    private static final Logger log = LoggerFactory.getLogger(SpringBootLambdaContainerHandler.class);
    private String[] springProfiles = null;
    private boolean initialized;

    public static SpringBootLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(Class<? extends WebApplicationInitializer> springBootInitializer) throws ContainerInitializationException {
        return new SpringBootLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>((RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), (Class<WebApplicationInitializer>)springBootInitializer);
    }

    public SpringBootLambdaContainerHandler(RequestReader<RequestType, AwsProxyHttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, Class<? extends WebApplicationInitializer> springBootInitializer) throws ContainerInitializationException {
        super(requestReader, responseWriter, securityContextWriter, exceptionHandler);
        Timer.start((String)"SPRINGBOOT_CONTAINER_HANDLER_CONSTRUCTOR");
        this.springBootInitializer = springBootInitializer;
        Timer.stop((String)"SPRINGBOOT_CONTAINER_HANDLER_CONSTRUCTOR");
    }

    public void activateSpringProfiles(String ... profiles) {
        this.springProfiles = profiles;
        this.initialized = false;
    }

    protected AwsHttpServletResponse getContainerResponse(AwsProxyHttpServletRequest request, CountDownLatch latch) {
        return new AwsHttpServletResponse((AwsHttpServletRequest)request, latch);
    }

    protected void handleRequest(AwsProxyHttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
        Timer.start((String)"SPRINGBOOT_HANDLE_REQUEST");
        if (this.getServletContext() == null) {
            this.setServletContext((ServletContext)new SpringBootAwsServletContext());
        }
        if (!this.initialized) {
            Timer.start((String)"SPRINGBOOT_COLD_START");
            if (this.springProfiles != null && this.springProfiles.length > 0) {
                System.setProperty("spring.profiles.active", String.join((CharSequence)",", this.springProfiles));
            }
            SpringServletContainerInitializer springServletContainerInitializer = new SpringServletContainerInitializer();
            LinkedHashSet<Class<? extends WebApplicationInitializer>> webAppInitializers = new LinkedHashSet<Class<? extends WebApplicationInitializer>>();
            webAppInitializers.add(this.springBootInitializer);
            springServletContainerInitializer.onStartup(webAppInitializers, this.getServletContext());
            if (this.springProfiles != null && this.springProfiles.length > 0) {
                StandardEnvironment springEnv = new StandardEnvironment();
                springEnv.setActiveProfiles(this.springProfiles);
            }
            this.initialized = true;
            Timer.stop((String)"SPRINGBOOT_COLD_START");
        }
        containerRequest.setServletContext(this.getServletContext());
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        DispatcherServlet dispatcherServlet = (DispatcherServlet)applicationContext.getBean("dispatcherServlet", DispatcherServlet.class);
        this.doFilter((HttpServletRequest)containerRequest, (HttpServletResponse)containerResponse, (Servlet)dispatcherServlet);
        Timer.stop((String)"SPRINGBOOT_HANDLE_REQUEST");
    }

    private class SpringBootAwsServletContext
    extends AwsServletContext {
        public SpringBootAwsServletContext() {
            super((AwsLambdaServletContainerHandler)SpringBootLambdaContainerHandler.this);
        }

        public ServletRegistration.Dynamic addServlet(String s, String s1) {
            throw new UnsupportedOperationException("Only dispatcherServlet is supported");
        }

        public ServletRegistration.Dynamic addServlet(String s, Class<? extends Servlet> aClass) {
            throw new UnsupportedOperationException("Only dispatcherServlet is supported");
        }

        public ServletRegistration.Dynamic addServlet(final String s, Servlet servlet) {
            if ("dispatcherServlet".equals(s)) {
                try {
                    servlet.init(new ServletConfig(){

                        public String getServletName() {
                            return s;
                        }

                        public ServletContext getServletContext() {
                            return SpringBootAwsServletContext.this;
                        }

                        public String getInitParameter(String name) {
                            return null;
                        }

                        public Enumeration<String> getInitParameterNames() {
                            return new Enumeration<String>(){

                                @Override
                                public boolean hasMoreElements() {
                                    return false;
                                }

                                @Override
                                public String nextElement() {
                                    return null;
                                }
                            };
                        }
                    });
                }
                catch (ServletException e) {
                    throw new RuntimeException("Cannot add servlet " + servlet, e);
                }
                return new ServletRegistration.Dynamic(){

                    public String getName() {
                        return s;
                    }

                    public String getClassName() {
                        return null;
                    }

                    public boolean setInitParameter(String name, String value) {
                        return false;
                    }

                    public String getInitParameter(String name) {
                        return null;
                    }

                    public Set<String> setInitParameters(Map<String, String> initParameters) {
                        return null;
                    }

                    public Map<String, String> getInitParameters() {
                        return null;
                    }

                    public Set<String> addMapping(String ... urlPatterns) {
                        return null;
                    }

                    public Collection<String> getMappings() {
                        return null;
                    }

                    public String getRunAsRole() {
                        return null;
                    }

                    public void setAsyncSupported(boolean isAsyncSupported) {
                    }

                    public void setLoadOnStartup(int loadOnStartup) {
                    }

                    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
                        return null;
                    }

                    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
                    }

                    public void setRunAsRole(String roleName) {
                    }
                };
            }
            throw new UnsupportedOperationException("Only dispatcherServlet is supported");
        }
    }
}

