/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.spring.LambdaSpringApplicationInitializer;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.concurrent.CountDownLatch;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class SpringLambdaContainerHandler<RequestType, ResponseType>
extends AwsLambdaServletContainerHandler<RequestType, ResponseType, AwsProxyHttpServletRequest, AwsHttpServletResponse> {
    private LambdaSpringApplicationInitializer initializer;
    private boolean initialized;

    public static SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(Class ... config) throws ContainerInitializationException {
        AnnotationConfigWebApplicationContext applicationContext = new AnnotationConfigWebApplicationContext();
        applicationContext.register(config);
        return SpringLambdaContainerHandler.getAwsProxyHandler((ConfigurableWebApplicationContext)applicationContext);
    }

    public static SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(ConfigurableWebApplicationContext applicationContext) throws ContainerInitializationException {
        SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> newHandler = new SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>(AwsProxyRequest.class, AwsProxyResponse.class, (RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), applicationContext);
        newHandler.initialize();
        return newHandler;
    }

    public static SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(ConfigurableWebApplicationContext applicationContext, String ... profiles) throws ContainerInitializationException {
        SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> newHandler = new SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>(AwsProxyRequest.class, AwsProxyResponse.class, (RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), applicationContext);
        newHandler.activateSpringProfiles(profiles);
        newHandler.initialize();
        return newHandler;
    }

    public SpringLambdaContainerHandler(Class<RequestType> requestTypeClass, Class<ResponseType> responseTypeClass, RequestReader<RequestType, AwsProxyHttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, ConfigurableWebApplicationContext applicationContext) throws ContainerInitializationException {
        super(requestTypeClass, responseTypeClass, requestReader, responseWriter, securityContextWriter, exceptionHandler);
        Timer.start((String)"SPRING_CONTAINER_HANDLER_CONSTRUCTOR");
        this.initialized = false;
        this.initializer = new LambdaSpringApplicationInitializer(applicationContext);
        Timer.stop((String)"SPRING_CONTAINER_HANDLER_CONSTRUCTOR");
    }

    public void setRefreshContext(boolean refreshContext) {
        this.initializer.setRefreshContext(refreshContext);
    }

    public LambdaSpringApplicationInitializer getApplicationInitializer() {
        return this.initializer;
    }

    protected AwsHttpServletResponse getContainerResponse(AwsProxyHttpServletRequest request, CountDownLatch latch) {
        return new AwsHttpServletResponse((AwsHttpServletRequest)request, latch);
    }

    public void activateSpringProfiles(String ... profiles) throws ContainerInitializationException {
        if (this.initializer == null) {
            throw new ContainerInitializationException("No application context or configuration classes provided", null);
        }
        this.setServletContext((ServletContext)new AwsServletContext((AwsLambdaServletContainerHandler)this));
        this.initializer.setSpringProfiles(this.getServletContext(), profiles);
    }

    protected void handleRequest(AwsProxyHttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
        Timer.start((String)"SPRING_HANDLE_REQUEST");
        if (this.initializer == null) {
            throw new ContainerInitializationException("No application context or configuration classes provided", null);
        }
        if (!this.initialized) {
            this.initialize();
        }
        containerRequest.setServletContext(this.getServletContext());
        this.doFilter((HttpServletRequest)containerRequest, (HttpServletResponse)containerResponse, (Servlet)this.initializer);
        Timer.stop((String)"SPRING_HANDLE_REQUEST");
    }

    public void initialize() throws ContainerInitializationException {
        Timer.start((String)"SPRING_COLD_START");
        try {
            this.initializer.onStartup(this.getServletContext());
        }
        catch (ServletException e) {
            throw new ContainerInitializationException("Could not initialize Spring", (Exception)((Object)e));
        }
        this.initialized = true;
        Timer.stop((String)"SPRING_COLD_START");
    }
}

