/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

@SuppressFBWarnings(value={"MTIA_SUSPECT_SERVLET_INSTANCE_FIELD"})
public class LambdaSpringApplicationInitializer
extends HttpServlet
implements WebApplicationInitializer {
    public static final String ERROR_NO_CONTEXT = "No application context or configuration classes provided";
    private static final String DEFAULT_SERVLET_NAME = "aws-servless-java-container";
    private static final long serialVersionUID = 42L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private volatile transient ConfigurableWebApplicationContext applicationContext;
    private volatile boolean refreshContext = true;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private volatile transient List<ServletContextListener> contextListeners;
    private volatile List<String> springProfiles;
    private volatile DispatcherServlet dispatcherServlet;
    private volatile transient HttpServletResponse currentResponse;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient Logger log = LoggerFactory.getLogger(LambdaSpringApplicationInitializer.class);

    public LambdaSpringApplicationInitializer(ConfigurableWebApplicationContext applicationContext) {
        this.contextListeners = new ArrayList<ServletContextListener>();
        this.applicationContext = applicationContext;
    }

    public void addListener(ServletContextListener listener) {
        this.contextListeners.add(listener);
    }

    public void setRefreshContext(boolean refreshContext) {
        this.refreshContext = refreshContext;
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.currentResponse = response;
        this.dispatcherServlet.service((ServletRequest)request, (ServletResponse)response);
    }

    public DispatcherServlet getDispatcherServlet() {
        return this.dispatcherServlet;
    }

    public void setSpringProfiles(ServletContext ctx, String ... springProfiles) throws ContainerInitializationException {
        this.springProfiles = Arrays.asList(springProfiles);
        this.applicationContext.registerShutdownHook();
        this.applicationContext.close();
        this.contextListeners.clear();
        try {
            this.onStartup(ctx);
        }
        catch (ServletException e) {
            throw new ContainerInitializationException("Could not reload Spring context", (Exception)((Object)e));
        }
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        Timer.start((String)"SPRING_INITIALIZER_ONSTARTUP");
        if (this.springProfiles != null) {
            this.applicationContext.getEnvironment().setActiveProfiles(this.springProfiles.toArray(new String[0]));
        }
        this.applicationContext.setServletContext(servletContext);
        DefaultDispatcherConfig dispatcherConfig = new DefaultDispatcherConfig(servletContext);
        this.applicationContext.setServletConfig((ServletConfig)dispatcherConfig);
        this.addListener((ServletContextListener)new ContextLoaderListener((WebApplicationContext)this.applicationContext));
        this.dispatcherServlet = new DispatcherServlet((WebApplicationContext)this.applicationContext);
        if (this.refreshContext) {
            this.dispatcherServlet.refresh();
        }
        this.dispatcherServlet.onApplicationEvent(new ContextRefreshedEvent((ApplicationContext)this.applicationContext));
        this.dispatcherServlet.init((ServletConfig)dispatcherConfig);
        this.notifyStartListeners(servletContext);
        Timer.stop((String)"SPRING_INITIALIZER_ONSTARTUP");
    }

    private void notifyStartListeners(ServletContext context) {
        for (ServletContextListener listener : this.contextListeners) {
            listener.contextInitialized(new ServletContextEvent(context));
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Timer.start((String)"SPRING_INITIALIZER_SERVICE");
        Timer.start((String)"SPRING_INITIALIZER_SERVICE_CAST");
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException("Cannot service request that is not instance of HttpServletRequest");
        }
        if (!(res instanceof HttpServletResponse)) {
            throw new ServletException("Cannot work with response that is not instance of HttpServletResponse");
        }
        Timer.stop((String)"SPRING_INITIALIZER_SERVICE_CAST");
        this.dispatch((HttpServletRequest)req, (HttpServletResponse)res);
        Timer.stop((String)"SPRING_INITIALIZER_SERVICE");
    }

    private static class DefaultDispatcherConfig
    implements ServletConfig {
        private ServletContext servletContext;

        DefaultDispatcherConfig(ServletContext context) {
            this.servletContext = context;
        }

        public String getServletName() {
            return LambdaSpringApplicationInitializer.DEFAULT_SERVLET_NAME;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String s) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.emptyEnumeration();
        }
    }
}

