/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.ServletLambdaContainerHandlerBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.spring.SpringLambdaContainerHandler;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class SpringProxyHandlerBuilder<RequestType>
extends ServletLambdaContainerHandlerBuilder<RequestType, AwsProxyResponse, HttpServletRequest, SpringLambdaContainerHandler<RequestType, AwsProxyResponse>, SpringProxyHandlerBuilder<RequestType>> {
    private ConfigurableWebApplicationContext springContext;
    private Class[] configurationClasses;
    private String[] profiles;

    protected SpringProxyHandlerBuilder<RequestType> self() {
        return this;
    }

    public SpringProxyHandlerBuilder<RequestType> springApplicationContext(ConfigurableWebApplicationContext app) {
        this.springContext = app;
        return this.self();
    }

    public SpringProxyHandlerBuilder<RequestType> configurationClasses(Class ... config) {
        this.configurationClasses = config;
        return this.self();
    }

    public SpringProxyHandlerBuilder<RequestType> profiles(String ... profiles) {
        this.profiles = profiles;
        return this.self();
    }

    public SpringLambdaContainerHandler<RequestType, AwsProxyResponse> build() throws ContainerInitializationException {
        this.validate();
        if (this.springContext == null && (this.configurationClasses == null || this.configurationClasses.length == 0)) {
            throw new ContainerInitializationException("Missing both configuration classes and application context, at least one of the two must be populated", null);
        }
        ConfigurableWebApplicationContext ctx = this.springContext;
        if (ctx == null) {
            ctx = new AnnotationConfigWebApplicationContext();
            if (this.configurationClasses != null) {
                ((AnnotationConfigWebApplicationContext)ctx).register(this.configurationClasses);
            }
        }
        SpringLambdaContainerHandler<RequestType, AwsProxyResponse> handler = this.createHandler(ctx);
        if (this.profiles != null) {
            handler.activateSpringProfiles(this.profiles);
        }
        return handler;
    }

    protected SpringLambdaContainerHandler<RequestType, AwsProxyResponse> createHandler(ConfigurableWebApplicationContext ctx) {
        return new SpringLambdaContainerHandler(this.requestTypeClass, this.responseTypeClass, this.requestReader, this.responseWriter, this.securityContextWriter, this.exceptionHandler, ctx, this.initializationWrapper);
    }

    public SpringLambdaContainerHandler<RequestType, AwsProxyResponse> buildAndInitialize() throws ContainerInitializationException {
        AwsLambdaServletContainerHandler handler = this.build();
        this.initializationWrapper.start((LambdaContainerHandler)handler);
        return handler;
    }
}

