/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.InitializationWrapper;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.serverless.proxy.spring.SpringProxyHandlerBuilder;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.concurrent.CountDownLatch;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class SpringLambdaContainerHandler<RequestType, ResponseType>
extends AwsLambdaServletContainerHandler<RequestType, ResponseType, HttpServletRequest, AwsHttpServletResponse> {
    protected final ConfigurableWebApplicationContext appContext;
    private String[] profiles;
    private boolean refreshContext = false;

    public static SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(Class<?> ... config) throws ContainerInitializationException {
        return ((SpringProxyHandlerBuilder)((SpringProxyHandlerBuilder)new SpringProxyHandlerBuilder().defaultProxy()).initializationWrapper(new InitializationWrapper())).configurationClasses(config).buildAndInitialize();
    }

    public static SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(ConfigurableWebApplicationContext applicationContext, String ... profiles) throws ContainerInitializationException {
        return ((SpringProxyHandlerBuilder)((SpringProxyHandlerBuilder)new SpringProxyHandlerBuilder().defaultProxy()).initializationWrapper(new InitializationWrapper())).springApplicationContext(applicationContext).profiles(profiles).buildAndInitialize();
    }

    public static SpringLambdaContainerHandler<HttpApiV2ProxyRequest, AwsProxyResponse> getHttpApiV2ProxyHandler(Class<?> ... config) throws ContainerInitializationException {
        return ((SpringProxyHandlerBuilder)((SpringProxyHandlerBuilder)new SpringProxyHandlerBuilder().defaultHttpApiV2Proxy()).initializationWrapper(new InitializationWrapper())).configurationClasses(config).buildAndInitialize();
    }

    public SpringLambdaContainerHandler(Class<RequestType> requestTypeClass, Class<ResponseType> responseTypeClass, RequestReader<RequestType, HttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, ConfigurableWebApplicationContext applicationContext, InitializationWrapper init) {
        super(requestTypeClass, responseTypeClass, requestReader, responseWriter, securityContextWriter, exceptionHandler);
        Timer.start((String)"SPRING_CONTAINER_HANDLER_CONSTRUCTOR");
        this.appContext = applicationContext;
        this.setInitializationWrapper(init);
        Timer.stop((String)"SPRING_CONTAINER_HANDLER_CONSTRUCTOR");
    }

    public void setRefreshContext(boolean refresh) {
        this.refreshContext = refresh;
    }

    protected AwsHttpServletResponse getContainerResponse(HttpServletRequest request, CountDownLatch latch) {
        return new AwsHttpServletResponse(request, latch);
    }

    public void activateSpringProfiles(String ... p) throws ContainerInitializationException {
        this.profiles = p;
        this.setServletContext((ServletContext)new AwsServletContext((AwsLambdaServletContainerHandler)this));
        this.appContext.registerShutdownHook();
        this.appContext.close();
        this.initialize();
    }

    protected void handleRequest(HttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
        Timer.start((String)"SPRING_HANDLE_REQUEST");
        if (this.refreshContext) {
            this.appContext.refresh();
            this.refreshContext = false;
        }
        if (AwsHttpServletRequest.class.isAssignableFrom(containerRequest.getClass())) {
            ((AwsHttpServletRequest)containerRequest).setServletContext(this.getServletContext());
            ((AwsHttpServletRequest)containerRequest).setResponse(containerResponse);
        }
        Servlet reqServlet = ((AwsServletContext)this.getServletContext()).getServletForPath(containerRequest.getPathInfo());
        this.doFilter(containerRequest, (HttpServletResponse)containerResponse, reqServlet);
        Timer.stop((String)"SPRING_HANDLE_REQUEST");
    }

    public void initialize() throws ContainerInitializationException {
        Timer.start((String)"SPRING_COLD_START");
        if (this.profiles != null) {
            this.appContext.getEnvironment().setActiveProfiles(this.profiles);
        }
        this.appContext.setServletContext(this.getServletContext());
        this.registerServlets();
        super.initialize();
        Timer.stop((String)"SPRING_COLD_START");
    }

    protected void registerServlets() {
        DispatcherServlet dispatcher = new DispatcherServlet((WebApplicationContext)this.appContext);
        ServletRegistration.Dynamic reg = this.getServletContext().addServlet("dispatcherServlet", (Servlet)dispatcher);
        reg.addMapping(new String[]{"/"});
        reg.setLoadOnStartup(1);
    }
}

