/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.InitializationWrapper;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.spring.SpringBootProxyHandlerBuilder;
import com.amazonaws.serverless.proxy.spring.embedded.ServerlessReactiveServletEmbeddedServerFactory;
import com.amazonaws.serverless.proxy.spring.embedded.ServerlessServletEmbeddedServerFactory;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.concurrent.CountDownLatch;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class SpringBootLambdaContainerHandler<RequestType, ResponseType>
extends AwsLambdaServletContainerHandler<RequestType, ResponseType, AwsProxyHttpServletRequest, AwsHttpServletResponse> {
    private final Class<?> springBootInitializer;
    private static final Logger log = LoggerFactory.getLogger(SpringBootLambdaContainerHandler.class);
    private String[] springProfiles = null;
    private static SpringBootLambdaContainerHandler instance;
    private boolean initialized;

    public static SpringBootLambdaContainerHandler getInstance() {
        return instance;
    }

    public static SpringBootLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(Class<?> springBootInitializer, String ... profiles) throws ContainerInitializationException {
        return ((SpringBootProxyHandlerBuilder)((SpringBootProxyHandlerBuilder)new SpringBootProxyHandlerBuilder().defaultProxy()).initializationWrapper(new InitializationWrapper())).springBootApplication(springBootInitializer).profiles(profiles).buildAndInitialize();
    }

    public SpringBootLambdaContainerHandler(Class<RequestType> requestTypeClass, Class<ResponseType> responseTypeClass, RequestReader<RequestType, AwsProxyHttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, Class<?> springBootInitializer, InitializationWrapper init) {
        super(requestTypeClass, responseTypeClass, requestReader, responseWriter, securityContextWriter, exceptionHandler);
        Timer.start((String)"SPRINGBOOT2_CONTAINER_HANDLER_CONSTRUCTOR");
        this.initialized = false;
        this.springBootInitializer = springBootInitializer;
        this.setInitializationWrapper(init);
        SpringBootLambdaContainerHandler.setInstance(this);
        Timer.stop((String)"SPRINGBOOT2_CONTAINER_HANDLER_CONSTRUCTOR");
    }

    private static void setInstance(SpringBootLambdaContainerHandler h) {
        instance = h;
    }

    public void activateSpringProfiles(String ... profiles) {
        this.springProfiles = profiles;
        this.initialized = false;
    }

    protected AwsHttpServletResponse getContainerResponse(AwsProxyHttpServletRequest request, CountDownLatch latch) {
        return new AwsHttpServletResponse((HttpServletRequest)request, latch);
    }

    protected void handleRequest(AwsProxyHttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
        Timer.start((String)"SPRINGBOOT2_HANDLE_REQUEST");
        if (!this.initialized) {
            this.initialize();
        }
        Servlet reqServlet = ((AwsServletContext)this.getServletContext()).getServletForPath(containerRequest.getPathInfo());
        containerRequest.setResponse(containerResponse);
        this.doFilter((HttpServletRequest)containerRequest, (HttpServletResponse)containerResponse, reqServlet);
        Timer.stop((String)"SPRINGBOOT2_HANDLE_REQUEST");
    }

    public void initialize() throws ContainerInitializationException {
        Timer.start((String)"SPRINGBOOT2_COLD_START");
        SpringApplication app = new SpringApplication((Class[])this.getEmbeddedContainerClasses());
        if (this.springProfiles != null && this.springProfiles.length > 0) {
            StandardEnvironment springEnv = new StandardEnvironment();
            springEnv.setActiveProfiles(this.springProfiles);
            app.setEnvironment((ConfigurableEnvironment)springEnv);
        }
        app.run(new String[0]);
        this.initialized = true;
        Timer.stop((String)"SPRINGBOOT2_COLD_START");
    }

    private Class<?>[] getEmbeddedContainerClasses() {
        Class[] classes = new Class[2];
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.springframework.web.reactive.HandlerAdapter");
            log.debug("Found WebFlux HandlerAdapter on classpath, using reactive server factory");
            classes[0] = ServerlessReactiveServletEmbeddedServerFactory.class;
        }
        catch (ClassNotFoundException e) {
            classes[0] = ServerlessServletEmbeddedServerFactory.class;
        }
        classes[1] = this.springBootInitializer;
        return classes;
    }
}

